/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.UuidSerializer;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class PlayerHandle {
    public static final UUID InvalidId = new UUID(0L, 0L);
    public static final PlayerHandle Invalid = new PlayerHandle((Entity)((LivingEntity)null));
    public final UUID id;
    public static final CompoundSerializable<PlayerHandle> Serializer = new SerializerImpl();

    public PlayerHandle(@Nonnull UUID id) {
        this.id = id;
    }

    public PlayerHandle(@Nullable Entity player) {
        this.id = player == null ? InvalidId : player.func_110124_au();
    }

    public static PlayerHandle from(@Nullable Entity player) {
        return new PlayerHandle(player);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerHandle that = (PlayerHandle)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public ServerPlayerEntity asEntity() {
        return Signpost.getServerInstance().func_184103_al().func_177451_a(this.id);
    }

    public static final class SerializerImpl
    implements CompoundSerializable<PlayerHandle> {
        @Override
        public CompoundNBT write(PlayerHandle playerHandle, CompoundNBT compound) {
            return UuidSerializer.INSTANCE.write(playerHandle.id, compound);
        }

        @Override
        public boolean isContainedIn(CompoundNBT compound) {
            return UuidSerializer.INSTANCE.isContainedIn(compound);
        }

        @Override
        public PlayerHandle read(CompoundNBT compound) {
            return new PlayerHandle(UuidSerializer.INSTANCE.read(compound));
        }

        @Override
        public Class<PlayerHandle> getTargetClass() {
            return PlayerHandle.class;
        }

        @Override
        public void write(PlayerHandle playerHandle, PacketBuffer buffer) {
            UuidSerializer.INSTANCE.write(playerHandle.id, buffer);
        }

        @Override
        public PlayerHandle read(PacketBuffer buffer) {
            return new PlayerHandle(UuidSerializer.INSTANCE.read(buffer));
        }
    }
}

