/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.BlockEventListener;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.commands.WaystoneArgument;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.data.DataGeneration;
import gollorum.signpost.minecraft.registry.BlockRegistry;
import gollorum.signpost.minecraft.registry.ItemRegistry;
import gollorum.signpost.minecraft.registry.RecipeRegistry;
import gollorum.signpost.minecraft.registry.TileEntityRegistry;
import gollorum.signpost.minecraft.rendering.PostRenderer;
import gollorum.signpost.minecraft.worldgen.WaystoneDiscoveryEventListener;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.relations.ExternalWaystoneLibrary;
import gollorum.signpost.relations.WaystonesAdapter;
import gollorum.signpost.utils.ServerType;
import gollorum.signpost.worldgen.Villages;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="signpost")
public class Signpost {
    public static final String MOD_ID = "signpost";
    public static final Logger LOGGER = LogManager.getLogger();
    private static MinecraftServer serverInstance;

    public static MinecraftServer getServerInstance() {
        return serverInstance;
    }

    public static ServerType getServerType() {
        return serverInstance == null ? ServerType.ConnectedClient : (serverInstance.func_71262_S() ? ServerType.Dedicated : ServerType.HostingClient);
    }

    public Signpost() {
        Config.register();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.register((Object)new ForgeEvents());
        modBus.register((Object)new ModBusEvents());
        BlockRegistry.register(modBus);
        ItemRegistry.register(modBus);
        RecipeRegistry.register(modBus);
        TileEntityRegistry.register(modBus);
        DataGeneration.register(modBus);
        BlockEventListener.register(forgeBus);
        WaystoneDiscoveryEventListener.register(forgeBus);
        Villages.instance.initialize();
        WaystoneArgument.bootstrap();
        if (ModList.get().isLoaded("waystones")) {
            WaystonesAdapter.register();
        }
    }

    private static final class JoinServerEvent
    implements PacketHandler.Event<Package> {
        private JoinServerEvent() {
        }

        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, PacketBuffer buffer) {
        }

        @Override
        public Package decode(PacketBuffer buffer) {
            return new Package();
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            WaystoneLibrary.initialize();
        }

        public static final class Package {
        }
    }

    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public void serverAboutToStart(FMLServerAboutToStartEvent e) {
            serverInstance = e.getServer();
            WaystoneLibrary.initialize();
            BlockRestrictions.initialize();
            Villages.instance.reset();
        }

        @SubscribeEvent
        public void joinServer(PlayerEvent.PlayerLoggedInEvent e) {
            if (!e.getPlayer().field_70170_p.field_72995_K && serverInstance.func_71262_S()) {
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getPlayer()), new JoinServerEvent.Package());
            }
        }

        @SubscribeEvent
        public void onServerStopped(FMLServerStoppedEvent event) {
            serverInstance = null;
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (event.getWorld() instanceof ServerWorld && event.getWorld().func_201675_m().func_186058_p().equals(DimensionType.field_223227_a_)) {
                ServerWorld world = (ServerWorld)event.getWorld();
                if (!WaystoneLibrary.getInstance().hasStorageBeenSetup()) {
                    WaystoneLibrary.getInstance().setupStorage(world);
                }
                if (!BlockRestrictions.getInstance().hasStorageBeenSetup()) {
                    BlockRestrictions.getInstance().setupStorage(world);
                }
            }
        }
    }

    private static class ModBusEvents {
        private ModBusEvents() {
        }

        @SubscribeEvent
        public void setup(FMLCommonSetupEvent event) {
            PacketHandler.initialize();
            PacketHandler.register(new JoinServerEvent(), -50);
            ExternalWaystoneLibrary.initialize();
            WaystoneLibrary.registerNetworkPackets();
        }

        @SubscribeEvent
        public void doClientStuff(FMLClientSetupEvent event) {
            ClientRegistry.bindTileEntityRenderer(PostTile.type, PostRenderer::new);
        }
    }
}

