/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.ConfirmTeleportGui;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.Inventory;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.relations.ExternalWaystone;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BufferSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class Teleport {
    public static void toWaystone(WaystoneHandle waystone, PlayerEntity player) {
        assert (Signpost.getServerType().isServer);
        if (waystone instanceof WaystoneHandle.Vanilla) {
            WaystoneLocationData waystoneData = WaystoneLibrary.getInstance().getLocationData((WaystoneHandle.Vanilla)waystone);
            Teleport.toWaystone(waystoneData, player);
        } else {
            Signpost.LOGGER.error("Tried to teleport to non-vanilla waystone " + ((ExternalWaystone.Handle)waystone).modMark());
        }
    }

    public static void toWaystone(WaystoneLocationData waystoneData, PlayerEntity player) {
        assert (Signpost.getServerType().isServer);
        waystoneData.block.world.mapLeft(Optional::of).leftOr(i -> TileEntityUtils.findWorld(i, false)).ifPresent(unspecificWorld -> {
            if (!(unspecificWorld instanceof ServerWorld)) {
                return;
            }
            ServerWorld world = (ServerWorld)unspecificWorld;
            Vector3 location = waystoneData.spawn;
            Vector3 diff = Vector3.fromBlockPos(waystoneData.block.blockPos).add(new Vector3(0.5f, 0.5f, 0.5f)).subtract(location.withY(y -> Float.valueOf(y.floatValue() + player.func_70047_e())));
            Angle yaw = Angle.between(0.0f, 1.0f, diff.x, diff.z);
            Angle pitch = Angle.fromRadians((float)(1.5707963267948966 + Math.atan(Math.sqrt(diff.x * diff.x + diff.z * diff.z) / (double)diff.y)));
            World oldWorld = player.field_70170_p;
            BlockPos oldPos = player.func_180425_c();
            if (!player.field_70170_p.func_201675_m().func_186058_p().equals(world.func_201675_m().func_186058_p())) {
                player.changeDimension(world.func_201675_m().func_186058_p(), new ITeleporter(){});
            }
            player.field_70177_z = yaw.degrees();
            player.field_70125_A = pitch.degrees();
            player.func_70634_a((double)location.x, (double)location.y, (double)location.z);
            int steps = 6;
            TriConsumer playStepSound = (soundWorld, pos, volume) -> {
                SoundType soundType = Blocks.field_150348_b.func_176223_P().func_215695_r();
                soundWorld.func_184133_a(null, pos, soundType.func_185844_d(), player.func_184176_by(), soundType.func_185843_a() * volume.floatValue(), soundType.func_185847_b());
            };
            AtomicReference<Consumer<Integer>> playStepSounds = new AtomicReference<Consumer<Integer>>();
            playStepSounds.set(countdown -> {
                float volume = (float)countdown.intValue() / 6.0f;
                playStepSound.accept((Object)oldWorld, (Object)oldPos, (Object)Float.valueOf(volume));
                if (countdown > 1) {
                    Delay.onServerForFrames(15, () -> ((Consumer)playStepSounds.get()).accept(countdown - 1));
                }
            });
            ((Consumer)playStepSounds.get()).accept(6);
        });
    }

    public static void requestOnClient(Either<String, RequestGui.Package.Info> data, Optional<ConfirmTeleportGui.SignInfo> signInfo) {
        ConfirmTeleportGui.display(data, signInfo);
    }

    public static ItemStack getCost(PlayerEntity player, Vector3 from, Vector3 to) {
        Item item = (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation((String)Config.Server.teleport.costItem.get()));
        if (item.equals(Items.field_190931_a) || player.func_184812_l_() || player.func_175149_v()) {
            return ItemStack.field_190927_a;
        }
        int distancePerPayment = (Integer)Config.Server.teleport.distancePerPayment.get();
        int distanceDependentCost = distancePerPayment < 0 ? 0 : (int)(from.distanceTo(to) / (float)distancePerPayment);
        return new ItemStack((IItemProvider)item, (Integer)Config.Server.teleport.constantPayment.get() + distanceDependentCost);
    }

    public static final class RequestGui
    implements PacketHandler.Event<Package> {
        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, PacketBuffer buffer) {
            Either.BufferSerializer.of(StringSerializer.instance, Package.Info.serializer).write(message.data, buffer);
            PostTile.TilePartInfo.Serializer.optional().write(message.tilePartInfo, buffer);
        }

        @Override
        public Package decode(PacketBuffer buffer) {
            return new Package((Either<String, Package.Info>)Either.BufferSerializer.of(StringSerializer.instance, Package.Info.serializer).read(buffer), (Optional<PostTile.TilePartInfo>)PostTile.TilePartInfo.Serializer.optional().read(buffer));
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            if (((Boolean)Config.Client.enableConfirmationScreen.get()).booleanValue()) {
                Teleport.requestOnClient(message.data, message.tilePartInfo.flatMap(info -> TileEntityUtils.findTileEntity(info.dimensionKey, true, info.pos, PostTile.class).flatMap(tile -> tile.getPart(info.identifier).flatMap(part -> part.blockPart instanceof SignBlockPart ? Optional.of(new ConfirmTeleportGui.SignInfo((PostTile)tile, (SignBlockPart)part.blockPart, (PostTile.TilePartInfo)info, part.offset)) : Optional.empty()))));
            } else {
                message.data.consume(l -> Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent(l, new Object[0]), true), r -> PacketHandler.sendToServer(new Request.Package(r.waystoneName)));
            }
        }

        public static final class Package {
            public final Either<String, Info> data;
            public final Optional<PostTile.TilePartInfo> tilePartInfo;

            public Package(Either<String, Info> data, Optional<PostTile.TilePartInfo> tilePartInfo) {
                this.data = data;
                this.tilePartInfo = tilePartInfo;
            }

            public static final class Info {
                public int maxDistance;
                public int distance;
                public boolean isDiscovered;
                public String waystoneName;
                public ItemStack cost;
                public static final Serializer serializer = new Serializer();

                public Info(int maxDistance, int distance, boolean isDiscovered, String waystoneName, ItemStack cost) {
                    this.maxDistance = maxDistance;
                    this.distance = distance;
                    this.isDiscovered = isDiscovered;
                    this.waystoneName = waystoneName;
                    this.cost = cost;
                }

                public static final class Serializer
                implements BufferSerializable<Info> {
                    @Override
                    public Class<Info> getTargetClass() {
                        return Info.class;
                    }

                    @Override
                    public void write(Info info, PacketBuffer buffer) {
                        buffer.writeInt(info.maxDistance);
                        buffer.writeInt(info.distance);
                        buffer.writeBoolean(info.isDiscovered);
                        StringSerializer.instance.write(info.waystoneName, buffer);
                        buffer.func_150788_a(info.cost);
                    }

                    @Override
                    public Info read(PacketBuffer buffer) {
                        return new Info(buffer.readInt(), buffer.readInt(), buffer.readBoolean(), StringSerializer.instance.read(buffer), buffer.func_150791_c());
                    }
                }
            }
        }
    }

    public static final class Request
    implements PacketHandler.Event<Package> {
        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, PacketBuffer buffer) {
            StringSerializer.instance.write(message.waystoneName, buffer);
        }

        @Override
        public Package decode(PacketBuffer buffer) {
            return new Package(StringSerializer.instance.read(buffer));
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            ServerPlayerEntity player = context.getSender();
            Optional<WaystoneHandle.Vanilla> waystone = WaystoneLibrary.getInstance().getHandleByName(message.waystoneName);
            if (waystone.isPresent()) {
                boolean isTooFarAway;
                WaystoneHandle.Vanilla handle = waystone.get();
                WaystoneLocationData waystoneData = WaystoneLibrary.getInstance().getLocationData(handle);
                boolean isDiscovered = WaystoneLibrary.getInstance().isDiscovered(PlayerHandle.from((Entity)player), handle) || (Boolean)Config.Server.teleport.enforceDiscovery.get() == false;
                int distance = (int)waystoneData.spawn.distanceTo(Vector3.fromVec3d(player.func_213303_ch()));
                int maxDistance = (Integer)Config.Server.teleport.maximumDistance.get();
                boolean bl = isTooFarAway = maxDistance > 0 && distance > maxDistance;
                if (!isDiscovered) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.not_discovered", new Object[]{message.waystoneName}));
                }
                if (isTooFarAway) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.too_far_away", new Object[]{Integer.toString(distance), Integer.toString(maxDistance)}));
                }
                if (!isDiscovered || isTooFarAway) {
                    return;
                }
                Inventory.tryPay((PlayerEntity)player, Teleport.getCost((PlayerEntity)player, Vector3.fromBlockPos(waystoneData.block.blockPos), waystoneData.spawn), p -> Teleport.toWaystone(waystoneData, p));
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.waystone_not_found", new Object[]{Colors.wrap(message.waystoneName, Colors.highlight)}));
            }
        }

        public static final class Package {
            public final String waystoneName;

            public Package(String waystoneName) {
                this.waystoneName = waystoneName;
            }
        }
    }
}

