/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.relations.ExternalWaystoneLibrary;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import gollorum.signpost.utils.serialization.UuidSerializer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public interface WaystoneHandle {
    public void write(PacketBuffer var1);

    public void write(CompoundNBT var1);

    public static Optional<WaystoneHandle> read(PacketBuffer buffer) {
        String type = StringSerializer.instance.read(buffer);
        if (type.equals("vanilla")) {
            return Optional.of(Vanilla.Serializer.read(buffer));
        }
        return ExternalWaystoneLibrary.getInstance().read(type, buffer);
    }

    public static Optional<WaystoneHandle> read(CompoundNBT compound) {
        String type = compound.func_74779_i("type");
        if (type.equals("vanilla")) {
            return Optional.of(Vanilla.Serializer.read(compound));
        }
        return ExternalWaystoneLibrary.getInstance().read(type, compound);
    }

    public static class Vanilla
    implements WaystoneHandle {
        public static final String typeTag = "vanilla";
        public static final Vanilla NIL = new Vanilla(PlayerHandle.InvalidId);
        public final UUID id;
        public static final CompoundSerializable<Vanilla> Serializer = new SerializerImpl();

        public Vanilla(UUID id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vanilla that = (Vanilla)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_180714_a(typeTag);
            Serializer.write(this, buffer);
        }

        @Override
        public void write(CompoundNBT compound) {
            Serializer.write(this, compound);
        }

        public static final class SerializerImpl
        implements CompoundSerializable<Vanilla> {
            @Override
            public CompoundNBT write(Vanilla playerHandle, CompoundNBT compound) {
                compound.func_74778_a("type", Vanilla.typeTag);
                UuidSerializer.INSTANCE.write(playerHandle.id, compound);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundNBT compound) {
                return UuidSerializer.INSTANCE.isContainedIn(compound);
            }

            @Override
            public Vanilla read(CompoundNBT compound) {
                return new Vanilla(UuidSerializer.INSTANCE.read(compound));
            }

            @Override
            public Class<Vanilla> getTargetClass() {
                return Vanilla.class;
            }

            @Override
            public void write(Vanilla playerHandle, PacketBuffer buffer) {
                UuidSerializer.INSTANCE.write(playerHandle.id, buffer);
            }

            @Override
            public Vanilla read(PacketBuffer buffer) {
                return new Vanilla(UuidSerializer.INSTANCE.read(buffer));
            }
        }
    }
}

