/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata;

import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.registry.ColorRegistry;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.World;

public abstract class Overlay {
    private static final Map<String, Overlay> overlayRegistry = new HashMap<String, Overlay>();
    public static final int NoTint = 0;
    public static final int GrasTint = 1;
    public static final int FoliageTint = 2;
    public static final int WaterTint = 3;
    public final int tintIndex;
    public final String id;
    public static final Overlay Gras = new Overlay(1, "gras"){

        @Override
        public ResourceLocation textureFor(Class<? extends SignBlockPart> signClass) {
            return signClass.equals(SmallWideSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_grass") : (signClass.equals(SmallShortSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_grass_short") : (signClass.equals(LargeSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_grass_large") : (ResourceLocation)Overlay.logErrorAndReturn("Sign class " + signClass + " is not supported by " + this, this.textureFor(SmallWideSignBlockPart.class))));
        }
    };
    public static final Overlay Vine = new Overlay(2, "vine"){

        @Override
        public ResourceLocation textureFor(Class<? extends SignBlockPart> signClass) {
            return signClass.equals(SmallWideSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_vine") : (signClass.equals(SmallShortSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_vine_short") : (signClass.equals(LargeSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_vine_large") : (ResourceLocation)Overlay.logErrorAndReturn("Sign class " + signClass + " is not supported by " + this, this.textureFor(SmallWideSignBlockPart.class))));
        }
    };
    public static final Overlay Snow = new Overlay(0, "snow"){

        @Override
        public ResourceLocation textureFor(Class<? extends SignBlockPart> signClass) {
            return signClass.equals(SmallWideSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_snow") : (signClass.equals(SmallShortSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_snow_short") : (signClass.equals(LargeSignBlockPart.class) ? new ResourceLocation("signpost", "block/sign_overlay_snow_large") : (ResourceLocation)Overlay.logErrorAndReturn("Sign class " + signClass + " is not supported by " + this, this.textureFor(SmallWideSignBlockPart.class))));
        }
    };
    public static final CompoundSerializable<Overlay> Serializer;

    public static void register(Overlay overlay) {
        overlayRegistry.put(overlay.id, overlay);
    }

    public static Collection<Overlay> getAllOverlays() {
        return overlayRegistry.values();
    }

    protected Overlay(int tintIndex, String id) {
        this.tintIndex = tintIndex;
        this.id = id;
    }

    public abstract ResourceLocation textureFor(Class<? extends SignBlockPart> var1);

    public int getTintAt(World world, BlockPos pos) {
        return ColorRegistry.getOverlayColor(this.tintIndex, world, pos);
    }

    public int getDefaultTint() {
        switch (this.tintIndex) {
            case 1: {
                return GrassColors.func_77480_a((double)0.8, (double)0.4);
            }
            case 2: {
                return FoliageColors.func_77468_c();
            }
            case 3: {
                return 4159204;
            }
        }
        return 0xFFFFFF;
    }

    private static <T> T logErrorAndReturn(String error, T t) {
        Signpost.LOGGER.error(error);
        return t;
    }

    static {
        Overlay.register(Gras);
        Overlay.register(Vine);
        Overlay.register(Snow);
        Serializer = new SerializerImpl();
    }

    public static final class SerializerImpl
    implements CompoundSerializable<Overlay> {
        @Override
        public Class<Overlay> getTargetClass() {
            return Overlay.class;
        }

        @Override
        public CompoundNBT write(Overlay overlay, CompoundNBT compound) {
            compound.func_74778_a("Id", overlay.id);
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundNBT compound) {
            return compound.func_74764_b("Id");
        }

        @Override
        public Overlay read(CompoundNBT compound) {
            String id = compound.func_74779_i("Id");
            if (!overlayRegistry.containsKey(id)) {
                Signpost.LOGGER.error("Tried to read overlay with id " + id + ", but it was not registered.");
                return Gras;
            }
            return (Overlay)overlayRegistry.get(id);
        }
    }
}

