/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Matrix4x4;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LargeSignBlockPart
extends SignBlockPart<LargeSignBlockPart> {
    private static final AABB LOCAL_BOUNDS = new AABB(new Vector3(-9.0f, -14.0f, 2.0f), new Vector3(12.0f, -2.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<LargeSignBlockPart> METADATA = new BlockPartMetadata<LargeSignBlockPart>("large_sign", (sign, compound) -> {
        compound.func_218657_a("CoreData", (INBT)SignBlockPart.CoreData.SERIALIZER.write(sign.coreData));
        compound.func_74778_a("Text0", sign.text[0]);
        compound.func_74778_a("Text1", sign.text[1]);
        compound.func_74778_a("Text2", sign.text[2]);
        compound.func_74778_a("Text3", sign.text[3]);
    }, compound -> new LargeSignBlockPart(SignBlockPart.CoreData.SERIALIZER.read(compound.func_74775_l("CoreData")), new String[]{compound.func_74779_i("Text0"), compound.func_74779_i("Text1"), compound.func_74779_i("Text2"), compound.func_74779_i("Text3")}), LargeSignBlockPart.class);
    private String[] text;

    public LargeSignBlockPart(SignBlockPart.CoreData coreData, String[] text) {
        super(coreData);
        assert (text.length == 4);
        this.text = text;
    }

    public LargeSignBlockPart(Angle angle, String[] text, boolean flip, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, ItemStack itemToDropOnBreak, PostBlock.ModelType modelType, boolean isLocked) {
        this(new SignBlockPart.CoreData(angle, flip, mainTexture, secondaryTexture, overlay, color, destination, modelType, itemToDropOnBreak, isLocked), text);
    }

    public void setText(String[] text) {
        this.text = text;
    }

    public String[] getText() {
        return this.text;
    }

    @Override
    protected void regenerateTransformedBox() {
        this.transformedBounds = new TransformedBox(LOCAL_BOUNDS).rotateAlong(Matrix4x4.Axis.Y, this.coreData.angle);
        if (this.coreData.flip) {
            this.transformedBounds = this.transformedBounds.scale(new Vector3(1.0f, 1.0f, -1.0f));
        }
    }

    private void notifyTextChanged(InteractionInfo info) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("Text0", this.text[0]);
        compound.func_74778_a("Text1", this.text[1]);
        compound.func_74778_a("Text2", this.text[2]);
        compound.func_74778_a("Text3", this.text[3]);
        info.mutationDistributor.accept(compound);
    }

    @Override
    public void readMutationUpdate(CompoundNBT compound, TileEntity tile, PlayerEntity editingPlayer) {
        if (editingPlayer != null && !editingPlayer.field_70170_p.func_201670_d() && tile instanceof WithOwner.OfSignpost && !this.hasThePermissionToEdit((WithOwner.OfSignpost)tile, editingPlayer)) {
            editingPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.no_permission_to_edit_signpost", new Object[0]));
            return;
        }
        if (compound.func_74764_b("Text0")) {
            this.text[0] = compound.func_74779_i("Text0");
        }
        if (compound.func_74764_b("Text1")) {
            this.text[1] = compound.func_74779_i("Text1");
        }
        if (compound.func_74764_b("Text2")) {
            this.text[2] = compound.func_74779_i("Text2");
        }
        if (compound.func_74764_b("Text3")) {
            this.text[3] = compound.func_74779_i("Text3");
        }
        super.readMutationUpdate(compound, tile, editingPlayer);
    }

    @Override
    public LargeSignBlockPart copy() {
        return new LargeSignBlockPart(this.coreData.copy(), this.text);
    }

    @Override
    public BlockPartMetadata<LargeSignBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public void writeTo(CompoundNBT compound) {
        METADATA.write(this, compound);
    }
}

