/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.PaintPostGui;
import gollorum.signpost.minecraft.gui.SignGui;
import gollorum.signpost.minecraft.gui.WaystoneGui;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.minecraft.utils.SideUtils;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class PostBlockPart
implements BlockPart<PostBlockPart> {
    private static final int maxSignCount = 10;
    private static final AABB BOUNDS = new AABB(new Vector3(-2.0f, -8.0f, -2.0f), new Vector3(2.0f, 8.0f, 2.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<PostBlockPart> METADATA = new BlockPartMetadata<PostBlockPart>("Post", (post, compound) -> compound.func_74778_a("texture", post.texture.toString()), compound -> new PostBlockPart(new ResourceLocation(compound.func_74779_i("texture"))), PostBlockPart.class);
    private ResourceLocation texture;

    public PostBlockPart(ResourceLocation texture) {
        this.setTexture(texture);
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return BOUNDS;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        ItemStack heldItem = info.player.func_184586_b(info.hand);
        PlayerHandle playerHandle = PlayerHandle.from((Entity)info.player);
        if (PostBlockPart.isValidSign(heldItem)) {
            return this.attachSign(info, heldItem);
        }
        if (PostBlockPart.isWaystone(heldItem)) {
            return this.attachWaystone(info, heldItem, playerHandle);
        }
        if (PostBlockPart.isBrush(heldItem)) {
            return this.paint(info);
        }
        return Interactable.InteractionResult.Ignored;
    }

    private Interactable.InteractionResult attachWaystone(InteractionInfo info, ItemStack heldItem, PlayerHandle playerHandle) {
        if (info.tile.getParts().stream().noneMatch(p -> p.blockPart instanceof WaystoneBlock)) {
            if (!info.isRemote && BlockRestrictions.getInstance().tryDecrementRemaining(BlockRestrictions.Type.Waystone, playerHandle)) {
                info.tile.addPart(new BlockPartInstance(new WaystoneBlockPart(playerHandle), Vector3.ZERO), new ItemStack((IItemProvider)heldItem.func_77973_b()), PlayerHandle.from((Entity)info.player));
                info.tile.func_70296_d();
                SideUtils.makePlayerPay(info.player, new ItemStack((IItemProvider)WaystoneBlock.INSTANCE));
            } else {
                WaystoneGui.display(new WorldLocation(info.tile.func_174877_v(), info.player.field_70170_p), Optional.empty());
            }
            return Interactable.InteractionResult.Accepted;
        }
        return Interactable.InteractionResult.Ignored;
    }

    private Interactable.InteractionResult attachSign(InteractionInfo info, ItemStack heldItem) {
        if (info.isRemote && info.tile.getParts().stream().filter(i -> i.blockPart instanceof SignBlockPart).count() < 10L) {
            SignGui.display(info.tile, PostBlock.ModelType.from(info.player.func_184586_b(info.hand).func_77973_b()).get(), info.traceResult.hitPos, new ItemStack((IItemProvider)heldItem.func_77973_b(), 1));
        }
        return Interactable.InteractionResult.Accepted;
    }

    private Interactable.InteractionResult paint(InteractionInfo info) {
        if (info.isRemote) {
            PaintPostGui.display(info.tile, this, info.traceResult.id);
        }
        return Interactable.InteractionResult.Accepted;
    }

    private static boolean isValidSign(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190916_E() < 1) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return PostBlock.ModelType.from(item).isPresent();
    }

    private static boolean isWaystone(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190916_E() < 1) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item.equals(WaystoneBlock.INSTANCE.func_199767_j());
    }

    private static boolean isBrush(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190916_E() < 1) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof Brush;
    }

    @Override
    public BlockPartMetadata<PostBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public void writeTo(CompoundNBT compound) {
        METADATA.write(this, compound);
    }

    private void notifyTextureChanged(InteractionInfo info) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("type", "texture");
        compound.func_74778_a("texture", this.texture.toString());
        info.mutationDistributor.accept(compound);
    }

    @Override
    public void readMutationUpdate(CompoundNBT compound, TileEntity tile, PlayerEntity editingPlayer) {
        this.setTexture(new ResourceLocation(compound.func_74779_i("texture")));
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner owner, PlayerEntity player) {
        return true;
    }

    @Override
    public Collection<ItemStack> getDrops(PostTile tile) {
        return Collections.emptySet();
    }

    @Override
    public Collection<ResourceLocation> getAllTextures() {
        return Collections.singleton(this.getTexture());
    }
}

