/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.Teleport;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.PaintSignGui;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.relations.ExternalWaystone;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ItemStackSerializer;
import gollorum.signpost.utils.serialization.OptionalBufferSerializer;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class SignBlockPart<Self extends SignBlockPart<Self>>
implements BlockPart<Self> {
    protected CoreData coreData;
    protected TransformedBox transformedBounds;

    public static Angle pointingAt(BlockPos block, BlockPos target) {
        BlockPos diff = target.func_177973_b((Vec3i)block);
        return Angle.between(diff.func_177958_n(), diff.func_177952_p(), 1.0f, 0.0f);
    }

    public Optional<WaystoneHandle> getDestination() {
        return this.coreData.destination;
    }

    protected SignBlockPart(CoreData coreData) {
        this.coreData = coreData;
        this.setAngle(coreData.angle);
        this.setTextures(coreData.mainTexture, coreData.secondaryTexture);
        this.setOverlay(coreData.overlay);
        this.setFlip(coreData.flip);
    }

    public void setAngle(Angle angle) {
        this.coreData.angle = angle;
        this.regenerateTransformedBox();
    }

    public void setFlip(boolean flip) {
        this.coreData.flip = flip;
        this.setTextures(this.coreData.mainTexture, this.coreData.secondaryTexture);
        this.setOverlay(this.coreData.overlay);
        this.regenerateTransformedBox();
    }

    public void setColor(int color) {
        this.coreData.color = color;
    }

    public void setDestination(Optional<WaystoneHandle> destination) {
        this.coreData.destination = destination;
    }

    public void setItemToDropOnBreak(ItemStack itemToDropOnBreak) {
        this.coreData.itemToDropOnBreak = itemToDropOnBreak;
    }

    private void setModelType(PostBlock.ModelType modelType) {
        this.coreData.modelType = modelType;
    }

    public ItemStack getItemToDropOnBreak() {
        return this.coreData.itemToDropOnBreak;
    }

    public boolean isFlipped() {
        return this.coreData.flip;
    }

    public int getColor() {
        return this.coreData.color;
    }

    public PostBlock.ModelType getModelType() {
        return this.coreData.modelType;
    }

    public boolean isLocked() {
        return this.coreData.isLocked;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, @Nullable PlayerEntity player) {
        return !(tile instanceof WithOwner.OfSignpost) || !this.coreData.isLocked || player == null || ((WithOwner.OfSignpost)tile).getSignpostOwner().map(o -> o.id.equals(player.func_110124_au())).orElse(true) != false || player.func_211513_k(((Integer)Config.Server.permissions.editLockedSignCommandPermissionLevel.get()).intValue());
    }

    private void setTextures(ResourceLocation texture, ResourceLocation textureDark) {
        this.coreData.mainTexture = texture;
        this.coreData.secondaryTexture = textureDark;
    }

    public ResourceLocation getMainTexture() {
        return this.coreData.mainTexture;
    }

    public ResourceLocation getSecondaryTexture() {
        return this.coreData.secondaryTexture;
    }

    public void setMainTexture(ResourceLocation tex) {
        this.coreData.mainTexture = tex;
    }

    public void setSecondaryTexture(ResourceLocation tex) {
        this.coreData.secondaryTexture = tex;
    }

    private void setOverlay(Optional<Overlay> overlay) {
        this.coreData.overlay = overlay;
    }

    public Optional<Overlay> getOverlay() {
        return this.coreData.overlay;
    }

    protected abstract void regenerateTransformedBox();

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return this.transformedBounds;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        ItemStack heldItem = info.player.func_184586_b(info.hand);
        if (!info.isRemote) {
            if (this.holdsAngleTool(info)) {
                if (info.player.func_213453_ef()) {
                    this.setFlip(!this.isFlipped());
                    this.notifyFlipChanged(info);
                } else {
                    Vector3 diff = info.traceResult.ray.start.negated().add(0.5f, 0.5f, 0.5f).withY(0.0f).normalized();
                    Vector3 rayDir = info.traceResult.ray.dir.withY(0.0f).normalized();
                    Angle angleToPost = Angle.between(rayDir.x, rayDir.z, diff.x, diff.z).normalized();
                    this.setAngle(this.coreData.angle.add(Angle.fromDegrees(angleToPost.radians() < 0.0f ? 15.0f : -15.0f)));
                    this.notifyAngleChanged(info);
                }
            } else if (!SignBlockPart.isBrush(heldItem)) {
                this.tryTeleport((ServerPlayerEntity)info.player, info.getTilePartInfo());
            }
        } else if (SignBlockPart.isBrush(heldItem)) {
            this.paint(info);
        }
        return Interactable.InteractionResult.Accepted;
    }

    private void tryTeleport(ServerPlayerEntity player, PostTile.TilePartInfo tilePartInfo) {
        if (((Boolean)Config.Server.teleport.enableTeleport.get()).booleanValue() && this.coreData.destination.isPresent() && (!(this.coreData.destination.get() instanceof WaystoneHandle.Vanilla) || WaystoneLibrary.getInstance().contains((WaystoneHandle.Vanilla)this.coreData.destination.get()))) {
            WaystoneHandle dest = this.coreData.destination.get();
            Optional vanillaHandle = dest instanceof WaystoneHandle.Vanilla ? Optional.of((WaystoneHandle.Vanilla)dest) : Optional.empty();
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new Teleport.RequestGui.Package(Either.rightIfPresent(vanillaHandle, () -> ((ExternalWaystone.Handle)dest).noTeleportLangKey()).mapRight(h -> {
                WaystoneData data = WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)h);
                boolean isDiscovered = WaystoneLibrary.getInstance().isDiscovered(new PlayerHandle((Entity)player), (WaystoneHandle.Vanilla)h) || (Boolean)Config.Server.teleport.enforceDiscovery.get() == false;
                int distance = (int)data.location.spawn.distanceTo(Vector3.fromVec3d(player.func_213303_ch()));
                return new Teleport.RequestGui.Package.Info((Integer)Config.Server.teleport.maximumDistance.get(), distance, isDiscovered, data.name, Teleport.getCost((PlayerEntity)player, Vector3.fromBlockPos(data.location.block.blockPos), data.location.spawn));
            }), Optional.of(tilePartInfo)));
        } else {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new RequestSignGui.Package(tilePartInfo));
        }
    }

    private boolean holdsAngleTool(InteractionInfo info) {
        ItemStack itemStack = info.player.func_184586_b(info.hand);
        return !itemStack.func_190926_b() && PostTile.isAngleTool(itemStack.func_77973_b());
    }

    private static boolean isBrush(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190916_E() < 1) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof Brush;
    }

    private Interactable.InteractionResult paint(InteractionInfo info) {
        if (info.isRemote) {
            PaintSignGui.display(info.tile, this, info.traceResult.id);
        }
        return Interactable.InteractionResult.Accepted;
    }

    protected void notifyAngleChanged(InteractionInfo info) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Angle", (INBT)Angle.Serializer.write(this.coreData.angle));
        info.mutationDistributor.accept(compound);
    }

    protected void notifyTextureChanged(InteractionInfo info) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("Texture", this.coreData.mainTexture.toString());
        compound.func_74778_a("TextureDark", this.coreData.secondaryTexture.toString());
        info.mutationDistributor.accept(compound);
    }

    protected void notifyFlipChanged(InteractionInfo info) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74757_a("Flip", this.coreData.flip);
        info.mutationDistributor.accept(compound);
    }

    @Override
    public void readMutationUpdate(CompoundNBT compound, TileEntity tile, PlayerEntity editingPlayer) {
        if (compound.func_74764_b("CoreData")) {
            compound = compound.func_74775_l("CoreData");
        }
        if (compound.func_74764_b("Angle")) {
            this.setAngle(Angle.Serializer.read(compound.func_74775_l("Angle")));
        }
        boolean updateTextures = false;
        if (compound.func_74764_b("Texture")) {
            this.coreData.mainTexture = new ResourceLocation(compound.func_74779_i("Texture"));
            updateTextures = true;
        }
        if (compound.func_74764_b("TextureDark")) {
            this.coreData.secondaryTexture = new ResourceLocation(compound.func_74779_i("TextureDark"));
            updateTextures = true;
        }
        if (updateTextures) {
            this.setTextures(this.coreData.mainTexture, this.coreData.secondaryTexture);
        }
        if (compound.func_74764_b("Flip")) {
            this.setFlip(compound.func_74767_n("Flip"));
        }
        if (compound.func_74764_b("Color")) {
            this.setColor(compound.func_74762_e("Color"));
        }
        if (compound.func_74764_b("Destination")) {
            CompoundNBT dest = compound.func_74775_l("Destination");
            if (dest.func_74767_n("IsPresent")) {
                Optional<WaystoneHandle> d2 = WaystoneHandle.read(dest);
                if (d2.isPresent()) {
                    this.setDestination(d2);
                } else {
                    Signpost.LOGGER.error("Error deserializing waystone handle of unknown type: " + dest.func_74779_i("type"));
                }
            } else {
                this.setDestination(Optional.empty());
            }
        }
        if (compound.func_74764_b("ItemToDropOnBreak")) {
            this.setItemToDropOnBreak(ItemStackSerializer.Instance.read(compound.func_74775_l("ItemToDropOnBreak")));
        }
        if (compound.func_74764_b("ModelType")) {
            PostBlock.ModelType.getByName(compound.func_74779_i("ModelType"), true).ifPresent(this::setModelType);
        }
        OptionalBufferSerializer overlaySerializer = Overlay.Serializer.optional();
        if (compound.func_74764_b("Overlay")) {
            this.setOverlay((Optional<Overlay>)((OptionalSerializer)overlaySerializer).read(compound.func_74775_l("Overlay")));
        }
        if (compound.func_74764_b("IsLocked") && (editingPlayer == null || editingPlayer.field_70170_p.func_201670_d() || ((WithOwner.OfSignpost)tile).getSignpostOwner().map(owner -> editingPlayer.func_110124_au().equals(owner.id)).orElse(true).booleanValue() || editingPlayer.func_211513_k(((Integer)Config.Server.permissions.editLockedSignCommandPermissionLevel.get()).intValue()))) {
            this.coreData.isLocked = compound.func_74767_n("IsLocked");
        }
        tile.func_70296_d();
    }

    @Override
    public Collection<ItemStack> getDrops(PostTile tile) {
        return Collections.singleton(this.coreData.itemToDropOnBreak);
    }

    private void dropOn(World world, BlockPos pos) {
        if (!this.coreData.itemToDropOnBreak.func_190926_b() && !world.func_201670_d()) {
            ItemEntity itementity = new ItemEntity(world, (double)pos.func_177958_n() + (double)world.func_201674_k().nextFloat() * 0.5 + 0.25, (double)pos.func_177956_o() + (double)world.func_201674_k().nextFloat() * 0.5 + 0.25, (double)pos.func_177952_p() + (double)world.func_201674_k().nextFloat() * 0.5 + 0.25, this.coreData.itemToDropOnBreak);
            itementity.func_174869_p();
            world.func_217376_c((Entity)itementity);
        }
    }

    public Angle getAngle() {
        return this.coreData.angle;
    }

    public abstract Self copy();

    @Override
    public Collection<ResourceLocation> getAllTextures() {
        return Arrays.asList(this.getMainTexture(), this.getSecondaryTexture());
    }

    protected static final class CoreData {
        public Angle angle;
        public boolean flip;
        public ResourceLocation mainTexture;
        public ResourceLocation secondaryTexture;
        public Optional<Overlay> overlay;
        public int color;
        public Optional<WaystoneHandle> destination;
        public PostBlock.ModelType modelType;
        public ItemStack itemToDropOnBreak;
        public boolean isLocked;
        public static final Serializer SERIALIZER = new Serializer();

        public CoreData(Angle angle, boolean flip, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, PostBlock.ModelType modelType, ItemStack itemToDropOnBreak, boolean isLocked) {
            this.angle = angle;
            this.flip = flip;
            this.mainTexture = mainTexture;
            this.secondaryTexture = secondaryTexture;
            this.overlay = overlay;
            this.color = color;
            this.destination = destination;
            this.modelType = modelType;
            this.itemToDropOnBreak = itemToDropOnBreak;
            this.isLocked = isLocked;
        }

        public CoreData copy() {
            return new CoreData(this.angle, this.flip, this.mainTexture, this.secondaryTexture, this.overlay, this.color, this.destination, this.modelType, this.itemToDropOnBreak, this.isLocked);
        }

        public static final class Serializer
        implements CompoundSerializable<CoreData> {
            private Serializer() {
            }

            @Override
            public CompoundNBT write(CoreData coreData, CompoundNBT compound) {
                compound.func_218657_a("Angle", (INBT)Angle.Serializer.write(coreData.angle));
                compound.func_74757_a("Flip", coreData.flip);
                compound.func_74778_a("Texture", coreData.mainTexture.toString());
                compound.func_74778_a("TextureDark", coreData.secondaryTexture.toString());
                compound.func_218657_a("Overlay", (INBT)Overlay.Serializer.optional().write(coreData.overlay));
                compound.func_74768_a("Color", coreData.color);
                CompoundNBT dest = new CompoundNBT();
                dest.func_74757_a("IsPresent", coreData.destination.isPresent());
                coreData.destination.ifPresent(d -> d.write(dest));
                compound.func_218657_a("Destination", (INBT)dest);
                compound.func_218657_a("ItemToDropOnBreak", (INBT)ItemStackSerializer.Instance.write(coreData.itemToDropOnBreak));
                compound.func_74778_a("ModelType", coreData.modelType.name);
                compound.func_74757_a("IsLocked", coreData.isLocked);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundNBT compound) {
                return compound.func_74764_b("Angle") && compound.func_74764_b("Flip") && compound.func_74764_b("Texture") && compound.func_74764_b("TextureDark") && compound.func_74764_b("Overlay") && compound.func_74764_b("Color") && compound.func_74764_b("Destination") && compound.func_74764_b("ItemToDropOnBreak") && compound.func_74764_b("IsLocked");
            }

            @Override
            public CoreData read(CompoundNBT compound) {
                Optional<WaystoneHandle> destination;
                CompoundNBT dest = compound.func_74775_l("Destination");
                if (dest.func_74767_n("IsPresent")) {
                    Optional<WaystoneHandle> d2 = WaystoneHandle.read(dest);
                    if (!d2.isPresent()) {
                        Signpost.LOGGER.error("Error deserializing waystone handle of unknown type: " + dest.func_74779_i("type"));
                    }
                    destination = d2;
                } else {
                    destination = Optional.empty();
                }
                return new CoreData(Angle.Serializer.read(compound.func_74775_l("Angle")), compound.func_74767_n("Flip"), new ResourceLocation(compound.func_74779_i("Texture")), new ResourceLocation(compound.func_74779_i("TextureDark")), (Optional<Overlay>)((OptionalSerializer)Overlay.Serializer.optional()).read(compound.func_74775_l("Overlay")), compound.func_74762_e("Color"), destination, PostBlock.ModelType.getByName(compound.func_74779_i("ModelType"), true).orElseThrow(() -> new RuntimeException("Tried to load sign post model type " + compound.func_74779_i("ModelType") + ", but it hasn't been registered. @Dev: You have to call Post.ModelType.register")), ItemStackSerializer.Instance.read(compound.func_74775_l("ItemToDropOnBreak")), compound.func_74767_n("IsLocked"));
            }

            @Override
            public Class<CoreData> getTargetClass() {
                return CoreData.class;
            }
        }
    }
}

