/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class WaystoneBlockPart
implements BlockPart<WaystoneBlockPart>,
WithOwner.OfWaystone {
    private Optional<PlayerHandle> owner;
    private static final AABB BOUNDS = new AABB(new Vector3(-3.0f, -8.0f, -3.0f), new Vector3(3.0f, -2.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<WaystoneBlockPart> METADATA = new BlockPartMetadata<WaystoneBlockPart>("Waystone", WaystoneBlockPart::writeTo, compound -> new WaystoneBlockPart((Optional<PlayerHandle>)((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.func_74775_l("owner"))), WaystoneBlockPart.class);

    public WaystoneBlockPart(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public WaystoneBlockPart(PlayerHandle owner) {
        this.owner = Optional.of(owner);
    }

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return BOUNDS;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        WaystoneBlock.onRightClick(info.player.field_70170_p, info.tile.func_174877_v(), info.player);
        return Interactable.InteractionResult.Accepted;
    }

    @Override
    public BlockPartMetadata<WaystoneBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public void writeTo(CompoundNBT compound) {
        compound.func_218657_a("owner", (INBT)((OptionalSerializer)PlayerHandle.Serializer.optional()).write(this.owner, new CompoundNBT()));
    }

    @Override
    public void readMutationUpdate(CompoundNBT compound, TileEntity tile, PlayerEntity editingPlayer) {
        if (compound.func_74764_b("owner")) {
            this.owner = ((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.func_74775_l("owner"));
        }
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, @Nullable PlayerEntity player) {
        return true;
    }

    @Override
    public Collection<ItemStack> getDrops(PostTile tile) {
        return Collections.singleton(new ItemStack((IItemProvider)WaystoneBlock.INSTANCE.func_199767_j()));
    }

    @Override
    public void removeFrom(PostTile tile) {
        if (tile.func_145830_o() && !tile.func_145831_w().func_201670_d()) {
            Optional<WorldLocation> location = WorldLocation.from(tile);
            if (location.isPresent()) {
                WaystoneLibrary.getInstance().removeAt(location.get(), PlayerHandle.Invalid);
            } else {
                Signpost.LOGGER.error("Waystone tile at " + tile.func_174877_v() + "  was removed but world was null. This means that the waystone has not been cleaned up correctly.");
            }
            this.getWaystoneOwner().ifPresent(o -> BlockRestrictions.getInstance().incrementRemaining(BlockRestrictions.Type.Waystone, (PlayerHandle)o));
        }
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    @Override
    public Collection<ResourceLocation> getAllTextures() {
        return Collections.singleton(TextureResource.waystoneTextureLocation);
    }
}

