/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.rendering.ModelRegistry;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.modelGeneration.SignModel;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;

public class LargeSignRenderer
extends SignRenderer<LargeSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = 0.4375f;
    private static final float TEXT_OFFSET_LEFT_SHORT = 0.5625f;
    private static final float TEXT_OFFSET_LEFT_LONG = 0.625f;
    private static final float MAXIMUM_TEXT_WIDTH_SHORT = 1.0f;
    private static final float MAXIMUM_TEXT_WIDTH_LONG = 1.0625f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected IBakedModel makeBakedModel(LargeSignBlockPart sign) {
        return ModelRegistry.LargeBakedSign.makeModel(sign);
    }

    @Override
    protected IBakedModel makeBakedOverlayModel(LargeSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.LargeBakedSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected SignModel makeModel(LargeSignBlockPart sign) {
        return ModelRegistry.LargeSign.makeModel(sign);
    }

    @Override
    protected SignModel makeOverlayModel(LargeSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.LargeSign.makeOverlayModel(sign, overlay);
    }

    @Override
    public void renderText(LargeSignBlockPart sign, MatrixStack matrix, FontRenderer fontRenderer, IRenderTypeBuffer buffer, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrix.func_227861_a_(0.0, 0.21875, -0.1878125);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[3], matrix, buffer, combinedLights, false));
            matrix.func_227861_a_(0.0, -0.1458333283662796, 0.0);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[2], matrix, buffer, combinedLights, false));
            matrix.func_227861_a_(0.0, -0.1458333283662796, 0.0);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[1], matrix, buffer, combinedLights, false));
            matrix.func_227861_a_(0.0, -0.1458333283662796, 0.0);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[0], matrix, buffer, combinedLights, false));
        });
    }

    private void render(LargeSignBlockPart sign, FontRenderer fontRenderer, String text, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLights, boolean isLong) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.func_78256_a(text) * scale / (isLong ? 1.0625f : 1.0f);
            float offset = 0.4375f * Math.min(1.0f, MAX_WIDTH_FRAC);
            matrix.func_227861_a_(sign.isFlipped() ? (double)(offset - (float)fontRenderer.func_78256_a(text) * (scale /= Math.max(1.0f, MAX_WIDTH_FRAC))) : (double)(-offset), (double)(-scale * 4.0f * 1.3f), 0.0);
            matrix.func_227862_a_(scale, scale * 1.3f, scale);
            fontRenderer.func_228079_a_(text, 0.0f, 0.0f, sign.getColor(), false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLights);
        });
    }
}

