/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.data.PostModel;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.SignModel;
import gollorum.signpost.utils.modelGeneration.SignModelFactory;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class PostRenderer
extends BlockPartRenderer<PostBlockPart> {
    private final boolean shouldRenderBaked = true;
    private static final Map<ResourceLocation, SignModel> cachedModels = new ConcurrentHashMap<ResourceLocation, SignModel>();
    private static final Map<ResourceLocation, IBakedModel> cachedBakedModels = new ConcurrentHashMap<ResourceLocation, IBakedModel>();

    private SignModel makeModel(PostBlockPart post) {
        return cachedModels.computeIfAbsent(post.getTexture(), x -> new SignModelFactory<ResourceLocation>().makePost((ResourceLocation)x).build(new SignModel(), SignModel::addCube));
    }

    private IBakedModel makeBakedModel(PostBlockPart post) {
        return cachedBakedModels.computeIfAbsent(post.getTexture(), x -> RenderingUtil.loadModel(PostModel.postLocation, post.getTexture()));
    }

    @Override
    public void render(PostBlockPart post, TileEntity tileEntity, TileEntityRendererDispatcher renderDispatcher, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLights, int combinedOverlay, Random random, long randomSeed) {
        RenderingUtil.render(matrix, renderModel -> renderModel.render(this.makeBakedModel(post), tileEntity.func_145831_w(), tileEntity.func_195044_w(), tileEntity.func_174877_v(), buffer.getBuffer(RenderType.func_228639_c_()), false, random, randomSeed, combinedOverlay, new Matrix4f(Quaternion.field_227060_a_)));
    }

    @Override
    public void renderGui(PostBlockPart post, MatrixStack matrixStack, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset) {
        RenderingUtil.renderGui(this.makeBakedModel(post), matrixStack, 0xFFFFFF, center, yaw, pitch, isFlipped, scale, offset, RenderType.func_228639_c_(), m -> {});
    }

    @Override
    public void renderGui(PostBlockPart post, MatrixStack matrixStack, Vector3 offset, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        RenderingUtil.renderGui(this.makeBakedModel(post), matrixStack, 0xFFFFFF, offset, Angle.ZERO, buffer.getBuffer(RenderType.func_228639_c_()), combinedLight, combinedOverlay, m -> {});
    }
}

