/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.rendering.ModelRegistry;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.MathUtils;
import gollorum.signpost.utils.modelGeneration.SignModel;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;

public class ShortSignRenderer
extends SignRenderer<SmallShortSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = -0.1875f;
    private static final float TEXT_OFFSET_LEFT = 0.84375f;
    private static final float MAXIMUM_TEXT_WIDTH = 0.65625f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected IBakedModel makeBakedModel(SmallShortSignBlockPart sign) {
        return ModelRegistry.ShortBakedSign.makeModel(sign);
    }

    @Override
    protected IBakedModel makeBakedOverlayModel(SmallShortSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.ShortBakedSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected SignModel makeModel(SmallShortSignBlockPart sign) {
        return ModelRegistry.ShortSign.makeModel(sign);
    }

    @Override
    protected SignModel makeOverlayModel(SmallShortSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.ShortSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected void renderText(SmallShortSignBlockPart sign, MatrixStack matrix, FontRenderer fontRenderer, IRenderTypeBuffer buffer, int combinedLights) {
        this.renderText(true, sign, matrix, fontRenderer, buffer, combinedLights);
        this.renderText(false, sign, matrix, fontRenderer, buffer, combinedLights);
    }

    private void renderText(boolean isFlipped, SmallShortSignBlockPart sign, MatrixStack matrix, FontRenderer fontRenderer, IRenderTypeBuffer buffer, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.func_78256_a(sign.getText()) * scale / 0.65625f;
            scale /= Math.max(1.0f, MAX_WIDTH_FRAC);
            boolean flipped = isFlipped ^ sign.isFlipped();
            if (isFlipped) {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.PI));
            }
            float offset = MathUtils.lerp(-0.1875f, -0.515625f, 1.0f - Math.min(1.0f, MAX_WIDTH_FRAC));
            matrix.func_227861_a_(flipped ? (double)(offset - (float)fontRenderer.func_78256_a(sign.getText()) * scale) : (double)(-offset), (double)(-scale * 4.0f * 1.3f), -0.0315625);
            matrix.func_227862_a_(scale, scale * 1.3f, scale);
            fontRenderer.func_228079_a_(sign.getText(), 0.0f, 0.0f, sign.getColor(), false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLights);
        });
    }
}

