/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.SignModel;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;

public abstract class SignRenderer<T extends SignBlockPart<T>>
extends BlockPartRenderer<T> {
    private final boolean shouldRenderBaked = false;

    protected abstract IBakedModel makeBakedModel(T var1);

    protected abstract IBakedModel makeBakedOverlayModel(T var1, Overlay var2);

    protected abstract SignModel makeModel(T var1);

    protected abstract SignModel makeOverlayModel(T var1, Overlay var2);

    @Override
    public void render(T sign, TileEntity tileEntity, TileEntityRendererDispatcher renderDispatcher, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLights, int combinedOverlay, Random random, long randomSeed) {
        RenderingUtil.render(matrix, renderModel -> {
            if (!tileEntity.func_145830_o()) {
                throw new RuntimeException("TileEntity without world cannot be rendered.");
            }
            RenderingUtil.wrapInMatrixEntry(matrix, () -> {
                Quaternion rotation = new Quaternion(Vector3f.field_229181_d_, sign.getAngle().radians(), false);
                matrix.func_227863_a_(rotation);
                RenderingUtil.wrapInMatrixEntry(matrix, () -> {
                    if (!sign.isFlipped()) {
                        matrix.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
                    }
                    this.renderText(sign, matrix, renderDispatcher.func_147548_a(), buffer, combinedLights);
                });
                Matrix4f rotationMatrix = new Matrix4f(rotation);
                this.makeModel(sign).render(matrix.func_227866_c_(), buffer, RenderType.func_228639_c_(), combinedLights, combinedOverlay, 1.0f, 1.0f, 1.0f);
                sign.getOverlay().ifPresent(o -> {
                    int tint = o.getTintAt(tileEntity.func_145831_w(), tileEntity.func_174877_v());
                    this.makeOverlayModel(sign, (Overlay)o).render(matrix.func_227866_c_(), buffer, RenderType.func_228641_d_(), combinedLights, combinedOverlay, (float)Colors.getRed(tint) / 255.0f, (float)Colors.getGreen(tint) / 255.0f, (float)Colors.getBlue(tint) / 255.0f);
                });
            });
        });
    }

    protected abstract void renderText(T var1, MatrixStack var2, FontRenderer var3, IRenderTypeBuffer var4, int var5);

    @Override
    public void renderGui(T sign, MatrixStack matrixStack, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset) {
        RenderingUtil.renderGui(this.makeBakedModel(sign), matrixStack, 0xFFFFFF, center, yaw.add(((SignBlockPart)sign).getAngle()), pitch, isFlipped, scale, offset, RenderType.func_228639_c_(), ms -> RenderingUtil.wrapInMatrixEntry(ms, () -> {
            if (!sign.isFlipped()) {
                ms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
            }
            this.renderText(sign, (MatrixStack)ms, Minecraft.func_71410_x().field_71466_p, (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), 0xF000F0);
        }));
        ((SignBlockPart)sign).getOverlay().ifPresent(o -> RenderingUtil.renderGui(this.makeBakedOverlayModel(sign, (Overlay)o), matrixStack, o.getDefaultTint(), center, yaw.add(sign.getAngle()), pitch, isFlipped, scale, offset, RenderType.func_228643_e_(), m -> {}));
    }

    @Override
    public void renderGui(T sign, MatrixStack matrixStack, Vector3 offset, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        RenderingUtil.renderGui(this.makeBakedModel(sign), matrixStack, 0xFFFFFF, offset, ((SignBlockPart)sign).getAngle(), buffer.getBuffer(RenderType.func_228639_c_()), combinedLight, combinedOverlay, ms -> RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            if (!sign.isFlipped()) {
                matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
            }
            this.renderText(sign, (MatrixStack)ms, Minecraft.func_71410_x().field_71466_p, buffer, combinedLight);
        }));
        ((SignBlockPart)sign).getOverlay().ifPresent(o -> RenderingUtil.renderGui(this.makeBakedOverlayModel(sign, (Overlay)o), matrixStack, o.getDefaultTint(), offset, sign.getAngle(), buffer.getBuffer(RenderType.func_228643_e_()), combinedLight, combinedOverlay, m -> {}));
    }
}

