/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.security.WithCountRestriction;
import gollorum.signpost.utils.Delay;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockEventListener {
    public static void register(IEventBus bus) {
        bus.register(BlockEventListener.class);
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!event.isCanceled() && event.getPlacedBlock().func_177230_c() instanceof WithCountRestriction) {
            BlockRestrictions.Type restrictionType = ((WithCountRestriction)event.getPlacedBlock().func_177230_c()).getBlockRestrictionType();
            PlayerHandle player = PlayerHandle.from(event.getEntity());
            if (!BlockRestrictions.getInstance().tryDecrementRemaining(restrictionType, player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRemoved(BlockEvent.BreakEvent event) {
        PostTile postTile;
        Optional<PostTile.TraceResult> traceResult;
        Block block = event.getState().func_177230_c();
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (!event.isCanceled() && tile instanceof PostTile && (traceResult = (postTile = (PostTile)tile).trace((Entity)event.getPlayer())).isPresent() && !(traceResult.get().part.blockPart instanceof PostBlockPart)) {
            event.setCanceled(true);
            Delay.onServerForFrames(1, () -> {
                postTile.removePart(((PostTile.TraceResult)traceResult.get()).id);
                if (event.getWorld() instanceof ServerWorld) {
                    ServerWorld world = (ServerWorld)event.getWorld();
                    if (!event.getPlayer().func_184812_l_()) {
                        BlockPos pos = tile.func_174877_v();
                        for (ItemStack item : ((PostTile.TraceResult)traceResult.get()).part.blockPart.getDrops(postTile)) {
                            ItemEntity itementity = new ItemEntity((World)world, (double)pos.func_177958_n() + (double)world.func_201674_k().nextFloat() * 0.5 + 0.25, (double)pos.func_177956_o() + (double)world.func_201674_k().nextFloat() * 0.5 + 0.25, (double)pos.func_177952_p() + (double)world.func_201674_k().nextFloat() * 0.5 + 0.25, item);
                            itementity.func_174869_p();
                            world.func_217376_c((Entity)itementity);
                        }
                    }
                }
            });
        }
        if (!event.isCanceled() && block instanceof WithCountRestriction) {
            BlockRestrictions.Type restrictionType = ((WithCountRestriction)block).getBlockRestrictionType();
            restrictionType.tryGetOwner.apply(tile).ifPresent(owner -> BlockRestrictions.getInstance().incrementRemaining(restrictionType, (PlayerHandle)owner));
        }
    }
}

