/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.security.WithCountRestriction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ModelWaystone
extends Block
implements IWaterLoggable,
WithCountRestriction {
    public static final BooleanProperty Waterlogged = BlockStateProperties.field_208198_y;
    public static final DirectionProperty Facing = BlockStateProperties.field_208157_J;
    private static final String REGISTRY_NAME = "waystone_model";
    public static final List<Variant> variants = new ArrayList<Variant>();
    public static Variant simple_0 = new Variant("simple_0", "0", VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_1 = new Variant("simple_1", "0", VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_2 = new Variant("simple_2", "0", VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), 0.0f);
    public static Variant detailed_0 = new Variant("detailed_0", "1", VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 2.0f);
    public static Variant detailed_1 = new Variant("detailed_1", "1", VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75), 0.0f);
    public static Variant aer = new Variant("aer", "2", VoxelShapes.func_197873_a((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.6f, (double)0.95f), 0.0f);
    public static Variant dwarf = new Variant("dwarf", "2", VoxelShapes.func_197873_a((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.4375, (double)0.95f), 2.0f);
    public static Variant ygnar = new Variant("ygnar", "2", VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875), 0.0f);
    public static final Variant generationMarker = simple_0;
    public final Variant variant;

    private ModelWaystone(Variant variant) {
        super(Block.Properties.func_200949_a((Material)Material.field_76233_E, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f).func_226896_b_());
        this.variant = variant;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)Waterlogged, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)Facing, (Comparable)Direction.NORTH));
    }

    public String func_149739_a() {
        return WaystoneBlock.INSTANCE.func_149739_a() + "_" + this.variant.langPrefix + "_" + this.variant.name;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        WaystoneBlock.onRightClick(world, pos, player);
        return ActionResultType.CONSUME;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{Waterlogged}).func_206894_a(new IProperty[]{Facing});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)Facing, (Comparable)context.func_195992_f());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (!state.func_196959_b((IProperty)Facing)) {
            return state;
        }
        Direction dir = (Direction)state.func_177229_b((IProperty)Facing);
        switch (rot) {
            case CLOCKWISE_90: {
                return (BlockState)state.func_206870_a((IProperty)Facing, (Comparable)dir.func_176746_e());
            }
            case CLOCKWISE_180: {
                return (BlockState)state.func_206870_a((IProperty)Facing, (Comparable)dir.func_176746_e().func_176746_e());
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)state.func_206870_a((IProperty)Facing, (Comparable)dir.func_176735_f());
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        if (!state.func_196959_b((IProperty)Facing)) {
            return state;
        }
        return (BlockState)state.func_206870_a((IProperty)Facing, (Comparable)((Direction)state.func_177229_b((IProperty)Facing)).func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WaystoneTile();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (((List)Config.Server.allowedWaystones.get()).contains(this.variant.name)) {
            super.func_149666_a(group, items);
        }
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)Waterlogged) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)Waterlogged) == false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.variant.shape;
    }

    @Override
    public BlockRestrictions.Type getBlockRestrictionType() {
        return BlockRestrictions.Type.Waystone;
    }

    static {
        variants.add(simple_0);
        variants.add(simple_1);
        variants.add(simple_2);
        variants.add(detailed_0);
        variants.add(detailed_1);
        variants.add(aer);
        variants.add(dwarf);
        variants.add(ygnar);
    }

    public static class Variant {
        public final String name;
        public final String registryName;
        public final String langPrefix;
        public final ModelWaystone block;
        public final VoxelShape shape;
        public final float modelYOffset;

        public Variant(String name, String langPrefix, VoxelShape shape, float modelYOffset) {
            this.name = name;
            this.registryName = "waystone_model_" + name;
            this.langPrefix = langPrefix;
            this.shape = shape;
            this.modelYOffset = modelYOffset;
            this.block = new ModelWaystone(this);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Variant && this.name.equals(((Variant)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

