/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PropertiesUtil;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithCountRestriction;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BufferSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.network.PacketDistributor;

public class PostBlock
extends Block
implements IWaterLoggable,
WithCountRestriction {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final String REGISTRY_NAME = "post";
    public static final Variant STONE = new Variant(PropertiesUtil.STONE, ModelType.Stone, "stone");
    public static final Variant IRON = new Variant(PropertiesUtil.IRON, ModelType.Iron, "iron");
    public static final Variant OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Oak), ModelType.Oak, "oak");
    public static final Variant DARK_OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.DarkOak), ModelType.DarkOak, "dark_oak");
    public static final Variant SPRUCE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Spruce), ModelType.Spruce, "spruce");
    public static final Variant BIRCH = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Birch), ModelType.Birch, "birch");
    public static final Variant JUNGLE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Jungle), ModelType.Jungle, "jungle");
    public static final Variant ACACIA = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Acacia), ModelType.Acacia, "acacia");
    public static final Variant SANDSTONE = new Variant(PropertiesUtil.STONE, ModelType.Sandstone, "sandstone");
    public static final List<Variant> AllVariants = Arrays.asList(OAK, BIRCH, SPRUCE, JUNGLE, DARK_OAK, ACACIA, STONE, IRON, SANDSTONE);
    public static final List<Block> ALL = AllVariants.stream().map(i -> i.block).collect(Collectors.toList());
    public final ModelType type;

    private PostBlock(Block.Properties properties, ModelType type) {
        super(properties.func_226896_b_());
        this.type = type;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack currentStack) {
        super.func_180633_a(world, pos, state, placer, currentStack);
        ItemStack stack = currentStack.func_77946_l();
        Delay.forFrames(6, world.func_201670_d(), () -> TileEntityUtils.delayUntilTileEntityExists((IWorld)world, pos, PostTile.class, tile -> {
            tile.setSignpostOwner(Optional.of(PlayerHandle.from((Entity)placer)));
            boolean shouldAddNewSign = placer instanceof ServerPlayerEntity;
            if (!world.func_201670_d()) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Parts")) {
                    tile.readParts(stack.func_77978_p().func_74775_l("Parts"));
                    shouldAddNewSign = false;
                } else {
                    tile.addPart(new BlockPartInstance(new PostBlockPart(this.type.postTexture), Vector3.ZERO), ItemStack.field_190927_a, PlayerHandle.from((Entity)placer));
                }
                tile.func_70296_d();
                world.func_184138_a(pos, state, state, 3);
                if (shouldAddNewSign) {
                    PacketHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)placer), new RequestSignGui.ForNewSign.Package(new WorldLocation(pos, world), tile.modelType, new Vector3(0.0f, 1.0f, 0.0f), ItemStack.field_190927_a));
                }
            }
        }, 100, Optional.of(() -> Signpost.LOGGER.error("Could not initialize placed signpost: TileEntity never appeared."))));
    }

    private void dropPartItems(PostTile tile, World world, BlockPos pos) {
        NonNullList drops = NonNullList.func_191196_a();
        drops.addAll(tile.getDrops());
        InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)drops);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity tile, ItemStack item) {
        if (!player.func_184812_l_() && tile instanceof PostTile && !EnchantmentHelper.func_82781_a((ItemStack)item).containsKey(Enchantments.field_185306_r)) {
            this.dropPartItems((PostTile)tile, world, pos);
        }
        super.func_180657_a(world, player, pos, state, tile, item);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack ret = super.getPickBlock(state, target, world, pos, player);
        TileEntityUtils.findTileEntity(world, pos, PostTile.class).ifPresent(tile -> {
            if (!ret.func_77942_o()) {
                ret.func_77982_d(new CompoundNBT());
            }
            ret.func_77978_p().func_218657_a("Parts", tile.writeParts(false));
        });
        return ret;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity t = world.func_175625_s(pos);
        return t instanceof PostTile ? ((PostTile)t).getBounds() : VoxelShapes.func_197880_a();
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PostTile(this.type, new ItemStack((IItemProvider)this));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof PostTile)) {
            return ActionResultType.SUCCESS;
        }
        PostTile tile = (PostTile)tileEntity;
        return PostBlock.onActivate(tile, world, player, hand);
    }

    public static ActionResultType onActivate(PostTile tile, World world, PlayerEntity player, Hand hand) {
        switch (tile.trace((Entity)player).map(p -> p.part.blockPart.interact(new InteractionInfo(InteractionInfo.Type.RightClick, player, hand, tile, (PostTile.TraceResult)p, data -> tile.notifyMutation(p.id, (CompoundNBT)data, p.part.blockPart.getMeta().identifier), world.func_201670_d()))).orElse(Interactable.InteractionResult.Ignored)) {
            case Accepted: {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    @Override
    public BlockRestrictions.Type getBlockRestrictionType() {
        return BlockRestrictions.Type.Signpost;
    }

    public static class Variant {
        public final PostBlock block;
        public final String registryName;
        public final Block.Properties properties;
        public final ModelType type;

        public Variant(Block.Properties properties, ModelType type, String registryName) {
            this.properties = properties;
            this.type = type;
            this.block = new PostBlock(properties, type);
            this.registryName = "post_" + registryName;
        }
    }

    public static class ModelType
    implements IStringSerializable {
        private static final Map<String, ModelType> allTypes = new HashMap<String, ModelType>();
        public static final ModelType Acacia = new ModelType("acacia", new ResourceLocation("acacia_log"), new ResourceLocation("stripped_acacia_log"), new ResourceLocation("acacia_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222075_kv})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_203297_q)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222075_kv})));
        public static final ModelType Birch = new ModelType("birch", new ResourceLocation("birch_log"), new ResourceLocation("stripped_birch_log"), new ResourceLocation("birch_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222073_kt})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_203296_p)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222073_kt})));
        public static final ModelType Iron = new ModelType("iron", new ResourceLocation("iron_block"), new ResourceLocation("signpost", "iron"), new ResourceLocation("signpost", "iron_dark"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_219773_J)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j})));
        public static final ModelType Jungle = new ModelType("jungle", new ResourceLocation("jungle_log"), new ResourceLocation("stripped_jungle_log"), new ResourceLocation("jungle_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222074_ku})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_203298_r)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222074_ku})));
        public static final ModelType Oak = new ModelType("oak", new ResourceLocation("oak_log"), new ResourceLocation("stripped_oak_log"), new ResourceLocation("oak_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222071_kr})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_203295_o)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222071_kr})));
        public static final ModelType DarkOak = new ModelType("darkoak", new ResourceLocation("dark_oak_log"), new ResourceLocation("stripped_dark_oak_log"), new ResourceLocation("dark_oak_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222076_kw})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_203294_n)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222076_kw})));
        public static final ModelType Spruce = new ModelType("spruce", new ResourceLocation("spruce_log"), new ResourceLocation("stripped_spruce_log"), new ResourceLocation("spruce_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222072_ks})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_203299_s)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222072_ks})));
        public static final ModelType Stone = new ModelType("stone", new ResourceLocation("stone"), new ResourceLocation("stone"), new ResourceLocation("signpost", "stone_dark"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_219773_J)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221574_b})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221574_b})));
        private static final Lazy<Ingredient> sandstone = Lazy.of(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150322_A, Blocks.field_196585_ak, Blocks.field_196583_aj, Blocks.field_196580_bH}));
        public static final ModelType Sandstone = new ModelType("sandstone", new ResourceLocation("sandstone"), new ResourceLocation("stripped_jungle_log"), new ResourceLocation("sandstone_bottom"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.func_199805_a((Tag)ItemTags.field_219773_J)), sandstone, sandstone);
        public final String name;
        public final ResourceLocation postTexture;
        public final ResourceLocation mainTexture;
        public final ResourceLocation secondaryTexture;
        public final Lazy<Ingredient> signIngredient;
        public final Lazy<Ingredient> baseIngredient;
        public final Lazy<Ingredient> addSignIngredient;
        public static BufferSerializable<ModelType> Serializer;

        public static void register(ModelType modelType, String name) {
            allTypes.put(name, modelType);
        }

        public static void register(ModelType modelType) {
            ModelType.register(modelType, modelType.name);
        }

        public static Optional<ModelType> getByName(String name, boolean logErrorIfNotPresent) {
            if (allTypes.containsKey(name)) {
                return Optional.of(allTypes.get(name));
            }
            if (logErrorIfNotPresent) {
                Signpost.LOGGER.error("Tried to get invalid model type " + name);
            }
            return Optional.empty();
        }

        public static Optional<ModelType> from(Item signItem) {
            return allTypes.values().stream().filter(t -> ((Ingredient)t.addSignIngredient.get()).test(new ItemStack((IItemProvider)signItem))).findFirst();
        }

        ModelType(String name, ResourceLocation postTexture, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Lazy<Ingredient> signIngredient, Lazy<Ingredient> baseIngredient, Lazy<Ingredient> addSignIngredient) {
            this.name = name;
            this.postTexture = ModelType.expand(postTexture);
            this.mainTexture = ModelType.expand(mainTexture);
            this.secondaryTexture = ModelType.expand(secondaryTexture);
            this.signIngredient = signIngredient;
            this.baseIngredient = baseIngredient;
            this.addSignIngredient = addSignIngredient;
        }

        private static ResourceLocation expand(ResourceLocation loc) {
            return new ResourceLocation(loc.func_110624_b(), loc.func_110623_a().startsWith("block/") ? loc.func_110623_a() : "block/" + loc.func_110623_a());
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            ModelType.register(Acacia);
            ModelType.register(Birch);
            ModelType.register(Iron);
            ModelType.register(Stone);
            ModelType.register(Jungle);
            ModelType.register(Oak);
            ModelType.register(DarkOak);
            ModelType.register(Spruce);
            ModelType.register(Sandstone);
            Serializer = new SerializerImpl();
        }

        public static final class SerializerImpl
        implements BufferSerializable<ModelType> {
            @Override
            public Class<ModelType> getTargetClass() {
                return ModelType.class;
            }

            @Override
            public void write(ModelType modelType, PacketBuffer buffer) {
                StringSerializer.instance.write(modelType.name, buffer);
                buffer.func_192572_a(modelType.postTexture);
                buffer.func_192572_a(modelType.mainTexture);
                buffer.func_192572_a(modelType.secondaryTexture);
                ((Ingredient)modelType.signIngredient.get()).func_199564_a(buffer);
                ((Ingredient)modelType.baseIngredient.get()).func_199564_a(buffer);
                ((Ingredient)modelType.addSignIngredient.get()).func_199564_a(buffer);
            }

            private <T> Lazy<T> constLazy(T t) {
                return Lazy.of(() -> t);
            }

            @Override
            public ModelType read(PacketBuffer buffer) {
                return new ModelType(StringSerializer.instance.read(buffer), buffer.func_192575_l(), buffer.func_192575_l(), buffer.func_192575_l(), this.constLazy(Ingredient.func_199566_b((PacketBuffer)buffer)), this.constLazy(Ingredient.func_199566_b((PacketBuffer)buffer)), this.constLazy(Ingredient.func_199566_b((PacketBuffer)buffer)));
            }
        }
    }
}

