/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.minecraft.utils.TextComponents;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithCountRestriction;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class WaystoneBlock
extends Block
implements WithCountRestriction {
    private static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final String REGISTRY_NAME = "waystone";
    public static final WaystoneBlock INSTANCE = new WaystoneBlock();

    private WaystoneBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_76233_E, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f));
    }

    public static void openGuiIfHasPermission(ServerPlayerEntity player, WorldLocation worldLocation) {
        assert (Signpost.getServerType().isServer);
        Optional<WaystoneData> data = WaystoneLibrary.getInstance().getHandleByLocation(worldLocation).map(WaystoneLibrary.getInstance()::getData);
        boolean wantsToOpenGui = !data.isPresent() || WaystoneLibrary.getInstance().isDiscovered(PlayerHandle.from((Entity)player), data.get().handle);
        boolean mayOpenGui = data.map(d -> d.hasThePermissionToEdit((PlayerEntity)player)).orElse(true);
        if (wantsToOpenGui && mayOpenGui) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new RequestWaystoneGui.Package(worldLocation, data));
        } else {
            WaystoneBlock.discover(player, data.get());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        WaystoneBlock.onRightClick(world, pos, player);
        return ActionResultType.CONSUME;
    }

    public static void onRightClick(World world, BlockPos pos, PlayerEntity player) {
        if (!world.func_201670_d() && player instanceof ServerPlayerEntity) {
            WaystoneBlock.openGuiIfHasPermission((ServerPlayerEntity)player, new WorldLocation(pos, world));
        }
    }

    private static void discover(ServerPlayerEntity player, WaystoneData data) {
        if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle(player.func_110124_au()), data.handle)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.discovered", new Object[]{TextComponents.waystone(player, data.name)}));
        }
    }

    public static void discover(PlayerHandle player, WaystoneData data) {
        ServerPlayerEntity playerEntity;
        assert (Signpost.getServerType().isServer);
        if (WaystoneLibrary.getInstance().addDiscovered(player, data.handle) && (playerEntity = player.asEntity()) != null) {
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.discovered", new Object[]{TextComponents.waystone(playerEntity, data.name)}));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WaystoneTile();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer);
    }

    public static void registerOwnerAndRequestGui(World world, BlockPos pos, LivingEntity placer) {
        Delay.forFrames(6, world.func_201670_d(), () -> TileEntityUtils.delayUntilTileEntityExists((IWorld)world, pos, WaystoneTile.class, t -> {
            t.setWaystoneOwner(Optional.of(PlayerHandle.from((Entity)placer)));
            if (placer instanceof ServerPlayerEntity) {
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)placer), new RequestWaystoneGui.Package(new WorldLocation(pos, world), Optional.empty()));
            }
        }, 100, Optional.empty()));
    }

    @Override
    public BlockRestrictions.Type getBlockRestrictionType() {
        return BlockRestrictions.Type.Waystone;
    }
}

