/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.items.Wrench;
import gollorum.signpost.minecraft.utils.SideUtils;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ItemStackSerializer;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import gollorum.signpost.utils.serialization.StringSerializer;
import gollorum.signpost.utils.serialization.UuidSerializer;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PostTile
extends TileEntity
implements WithOwner.OfSignpost,
WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "post";
    public static final TileEntityType<PostTile> type = TileEntityType.Builder.func_223042_a(() -> new PostTile(PostBlock.ModelType.Oak, ItemStack.field_190927_a), (Block[])PostBlock.ALL.toArray(new Block[0])).func_206865_a(null);
    private final Map<UUID, BlockPartInstance> parts = new ConcurrentHashMap<UUID, BlockPartInstance>();
    public static final Set<BlockPartMetadata<?>> partsMetadata = new ConcurrentSet();
    public final PostBlock.ModelType modelType;
    private ItemStack drop;
    private Optional<PlayerHandle> owner = Optional.empty();

    public PostTile(PostBlock.ModelType modelType, ItemStack drop) {
        super(type);
        this.modelType = modelType;
        this.drop = drop;
    }

    public UUID addPart(BlockPartInstance part, ItemStack cost, PlayerHandle player) {
        return this.addPart(UUID.randomUUID(), part, cost, player);
    }

    public UUID addPart(UUID identifier, BlockPartInstance part, ItemStack cost, PlayerHandle player) {
        this.parts.put(identifier, part);
        if (this.func_145830_o() && !this.func_145831_w().func_201670_d()) {
            this.sendToTracing(() -> new PartAddedEvent.Packet(new TilePartInfo(this, identifier), part.blockPart.write(), part.blockPart.getMeta().identifier, part.offset, cost, player));
        }
        return identifier;
    }

    public BlockPartInstance removePart(UUID id) {
        BlockPartInstance oldPart = this.parts.remove(id);
        if (oldPart == null) {
            Signpost.LOGGER.error("Failed to remove post block part with id " + id);
            return oldPart;
        }
        if (this.func_145831_w() != null && !this.func_145831_w().func_201670_d()) {
            this.sendToTracing(() -> new PartRemovedEvent.Packet(new TilePartInfo(this, id), false));
        }
        oldPart.blockPart.removeFrom(this);
        this.func_70296_d();
        return oldPart;
    }

    public void func_145843_s() {
        for (BlockPartInstance part : this.parts.values()) {
            part.blockPart.removeFrom(this);
        }
        super.func_145843_s();
    }

    public Collection<BlockPartInstance> getParts() {
        return this.parts.values();
    }

    public VoxelShape getBounds() {
        return this.parts.values().stream().map(t -> t.blockPart.getIntersection().getBounds().offset(t.offset).asMinecraftBB()).map(VoxelShapes::func_197881_a).reduce((b1, b2) -> VoxelShapes.func_197878_a((VoxelShape)b1, (VoxelShape)b2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197880_a());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        VoxelShape shape = this.getBounds();
        return shape.func_197766_b() ? new AxisAlignedBB(this.func_174877_v()) : shape.func_197752_a().func_186670_a(this.func_174877_v());
    }

    public Optional<TraceResult> trace(Entity player) {
        Vec3d head = player.func_213303_ch();
        head = head.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        if (player.func_213453_ef()) {
            head = head.func_178786_a(0.0, 0.08, 0.0);
        }
        Vec3d look = player.func_70040_Z();
        Ray ray = new Ray(Vector3.fromVec3d(head).subtract(Vector3.fromBlockPos(this.func_174877_v())), Vector3.fromVec3d(look));
        Optional<Tuple> closestTrace = Optional.empty();
        for (Map.Entry<UUID, BlockPartInstance> t : this.parts.entrySet()) {
            Optional<Float> now = t.getValue().blockPart.intersectWith(ray, t.getValue().offset);
            if (!now.isPresent() || closestTrace.isPresent() && !(((Float)((Tuple)closestTrace.get()).func_76340_b()).floatValue() > now.get().floatValue())) continue;
            closestTrace = Optional.of(new Tuple((Object)t.getKey(), (Object)now.get()));
        }
        return closestTrace.map(trace -> new TraceResult(this.parts.get(trace.func_76341_a()), (UUID)trace.func_76341_a(), ray.atDistance(((Float)trace.func_76340_b()).floatValue()), ray));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.writeSelf(compound);
        return compound;
    }

    public INBT writeParts(boolean includeIDs) {
        CompoundNBT compound = new CompoundNBT();
        for (Map.Entry<BlockPartMetadata, List<Map.Entry>> entry : this.parts.entrySet().stream().collect(Collectors.groupingBy(p -> ((BlockPartInstance)p.getValue()).blockPart.getMeta())).entrySet()) {
            List<Map.Entry> instances = entry.getValue();
            ListNBT list = new ListNBT();
            for (Map.Entry e : instances) {
                BlockPartInstance instance = (BlockPartInstance)e.getValue();
                CompoundNBT subComp = instance.blockPart.write();
                subComp.func_218657_a("Offset", (INBT)Vector3.Serializer.write(instance.offset));
                if (includeIDs) {
                    UuidSerializer.INSTANCE.write((UUID)e.getKey(), subComp);
                }
                list.add((Object)subComp);
            }
            compound.func_218657_a(entry.getKey().identifier, (INBT)list);
        }
        return compound;
    }

    private void writeSelf(CompoundNBT compound) {
        compound.func_218657_a("Parts", this.writeParts(true));
        compound.func_218657_a("Drop", (INBT)ItemStackSerializer.Instance.write(this.drop));
        compound.func_218657_a("Owner", (INBT)PlayerHandle.Serializer.optional().write(this.owner));
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readSelf(compound);
    }

    public static List<BlockPartInstance> readPartInstances(CompoundNBT compound) {
        ArrayList<BlockPartInstance> parts = new ArrayList<BlockPartInstance>();
        for (BlockPartMetadata<?> meta : partsMetadata) {
            if (!compound.func_74764_b(meta.identifier)) continue;
            ListNBT list = compound.func_150295_c(meta.identifier, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT comp = list.func_150305_b(i);
                parts.add(new BlockPartInstance((BlockPart)meta.read(comp), Vector3.Serializer.read(comp.func_74775_l("Offset"))));
            }
        }
        return parts;
    }

    public void readParts(CompoundNBT compound) {
        this.parts.clear();
        for (BlockPartMetadata<?> meta : partsMetadata) {
            if (!compound.func_74764_b(meta.identifier)) continue;
            ListNBT list = compound.func_150295_c(meta.identifier, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT comp = list.func_150305_b(i);
                this.addPart(UuidSerializer.INSTANCE.isContainedIn(comp) ? UuidSerializer.INSTANCE.read(comp) : UUID.randomUUID(), new BlockPartInstance((BlockPart)meta.read(comp), Vector3.Serializer.read(comp.func_74775_l("Offset"))), ItemStack.field_190927_a, PlayerHandle.Invalid);
            }
        }
    }

    private void readSelf(CompoundNBT compound) {
        this.readParts(compound.func_74775_l("Parts"));
        this.drop = ItemStackSerializer.Instance.read(compound.func_74775_l("Drop"));
        this.owner = ((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.func_74775_l("Owner"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT ret = super.func_189517_E_();
        this.writeSelf(ret);
        return ret;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT ret = new CompoundNBT();
        this.writeSelf(ret);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, ret);
    }

    public void handleUpdateTag(CompoundNBT compound) {
        super.handleUpdateTag(compound);
        this.readSelf(compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.readSelf(pkt.func_148857_g());
    }

    public void notifyMutation(UUID part, CompoundNBT data, String partMetaIdentifier) {
        this.sendToTracing(() -> new PartMutatedEvent.Packet(new TilePartInfo(this, part), data, partMetaIdentifier));
    }

    public <T> void sendToTracing(Supplier<T> t) {
        PacketHandler.sendToTracing(this, t);
    }

    public Collection<ItemStack> getDrops() {
        List<ItemStack> ret = this.parts.values().stream().flatMap(p -> p.blockPart.getDrops(this).stream()).collect(Collectors.toList());
        return ret;
    }

    public void setSignpostOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    @Override
    public Optional<PlayerHandle> getSignpostOwner() {
        return this.owner;
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.getParts().stream().filter(p -> p.blockPart instanceof WaystoneBlockPart).findFirst().flatMap(p -> ((WaystoneBlockPart)p.blockPart).getWaystoneOwner());
    }

    public static boolean isAngleTool(Item item) {
        return item instanceof Wrench;
    }

    public Optional<BlockPartInstance> getPart(UUID id) {
        return this.parts.containsKey(id) ? Optional.of(this.parts.get(id)) : Optional.empty();
    }

    static {
        partsMetadata.add(PostBlockPart.METADATA);
        partsMetadata.add(SmallWideSignBlockPart.METADATA);
        partsMetadata.add(SmallShortSignBlockPart.METADATA);
        partsMetadata.add(LargeSignBlockPart.METADATA);
        partsMetadata.add(WaystoneBlockPart.METADATA);
    }

    public static class PartMutatedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, PacketBuffer buffer) {
            TilePartInfo.Serializer.write(message.info, buffer);
            StringSerializer.instance.write(message.data.toString(), buffer);
            StringSerializer.instance.write(message.partMetaIdentifier, buffer);
            Vector3.Serializer.optional().write(message.offset, buffer);
        }

        @Override
        public Packet decode(PacketBuffer buffer) {
            try {
                return new Packet(TilePartInfo.Serializer.read(buffer), JsonToNBT.func_180713_a((String)StringSerializer.instance.read(buffer)), StringSerializer.instance.read(buffer), (Optional<Vector3>)Vector3.Serializer.optional().read(buffer));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            boolean isServer = context.getDirection().getReceptionSide().isServer();
            TileEntityUtils.findWorld(message.info.dimensionKey, !isServer).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(new WorldLocation(message.info.pos, (World)level), PostTile.class, tile -> {
                Optional<BlockPartInstance> part = tile.getPart(message.info.identifier);
                if (part.isPresent()) {
                    BlockPartInstance blockPartInstance = part.get();
                    if (blockPartInstance.blockPart.getMeta().identifier.equals(message.partMetaIdentifier)) {
                        blockPartInstance.blockPart.readMutationUpdate(message.data, (TileEntity)tile, (PlayerEntity)(isServer ? context.getSender() : null));
                        if (message.offset.isPresent()) {
                            ((PostTile)tile).parts.remove(message.info.identifier);
                            ((PostTile)tile).parts.put(message.info.identifier, new BlockPartInstance(blockPartInstance.blockPart, message.offset.get()));
                        }
                    } else {
                        Optional<BlockPartMetadata> meta = partsMetadata.stream().filter(m -> m.identifier.equals(message.partMetaIdentifier)).findFirst();
                        if (meta.isPresent()) {
                            ((PostTile)tile).parts.remove(message.info.identifier);
                            ((PostTile)tile).parts.put(message.info.identifier, new BlockPartInstance((BlockPart)meta.get().read(message.data), message.offset.orElse(blockPartInstance.offset)));
                        } else {
                            Signpost.LOGGER.warn("Could not find meta for part " + message.partMetaIdentifier);
                        }
                    }
                    tile.func_70296_d();
                    if (isServer) {
                        tile.sendToTracing(() -> message);
                    }
                } else {
                    Signpost.LOGGER.error("Tried to mutate a post part that wasn't present: " + message.info.identifier);
                }
            }, 100, !isServer, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartMutatedEvent, tile was not present"))));
        }

        public static class Packet {
            public final TilePartInfo info;
            public final CompoundNBT data;
            public final String partMetaIdentifier;
            public final Optional<Vector3> offset;

            public Packet(TilePartInfo info, CompoundNBT data, String partMetaIdentifier) {
                this(info, data, partMetaIdentifier, Optional.empty());
            }

            public Packet(TilePartInfo info, CompoundNBT data, String partMetaIdentifier, Vector3 offset) {
                this(info, data, partMetaIdentifier, Optional.of(offset));
            }

            public Packet(TilePartInfo info, CompoundNBT data, String partMetaIdentifier, Optional<Vector3> offset) {
                this.info = info;
                this.data = data;
                this.partMetaIdentifier = partMetaIdentifier;
                this.offset = offset;
            }
        }
    }

    public static class PartRemovedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, PacketBuffer buffer) {
            TilePartInfo.Serializer.write(message.info, buffer);
            buffer.writeBoolean(message.shouldDropItem);
        }

        @Override
        public Packet decode(PacketBuffer buffer) {
            return new Packet(TilePartInfo.Serializer.read(buffer), buffer.readBoolean());
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            boolean isClient = context.getDirection().getReceptionSide().isClient();
            TileEntityUtils.findWorld(message.info.dimensionKey, isClient).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(new WorldLocation(message.info.pos, (World)level), PostTile.class, tile -> {
                BlockPartInstance oldPart = tile.removePart(message.info.identifier);
                if (oldPart != null && !tile.func_145831_w().func_201670_d() && !context.getSender().func_184812_l_() && message.shouldDropItem) {
                    for (ItemStack item : oldPart.blockPart.getDrops((PostTile)tile)) {
                        if (context.getSender().field_71071_by.func_70441_a(item) || !(tile.func_145831_w() instanceof ServerWorld)) continue;
                        ServerWorld serverWorld = (ServerWorld)tile.func_145831_w();
                        BlockPos pos = message.info.pos;
                        ItemEntity itementity = new ItemEntity((World)serverWorld, (double)pos.func_177958_n() + (double)serverWorld.func_201674_k().nextFloat() * 0.5 + 0.25, (double)pos.func_177956_o() + (double)serverWorld.func_201674_k().nextFloat() * 0.5 + 0.25, (double)pos.func_177952_p() + (double)serverWorld.func_201674_k().nextFloat() * 0.5 + 0.25, item);
                        itementity.func_174869_p();
                        serverWorld.func_217376_c((Entity)itementity);
                    }
                }
            }, 100, isClient, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartRemovedEvent, tile was not present"))));
        }

        public static class Packet {
            public final TilePartInfo info;
            public final boolean shouldDropItem;

            public Packet(TilePartInfo info, boolean shouldDropItem) {
                this.info = info;
                this.shouldDropItem = shouldDropItem;
            }
        }
    }

    public static class PartAddedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, PacketBuffer buffer) {
            TilePartInfo.Serializer.write(message.info, buffer);
            StringSerializer.instance.write(message.partData.func_150285_a_(), buffer);
            StringSerializer.instance.write(message.partMetaIdentifier, buffer);
            Vector3.Serializer.write(message.offset, buffer);
            buffer.func_150788_a(message.cost);
            PlayerHandle.Serializer.write(message.player, buffer);
        }

        @Override
        public Packet decode(PacketBuffer buffer) {
            try {
                return new Packet(TilePartInfo.Serializer.read(buffer), JsonToNBT.func_180713_a((String)StringSerializer.instance.read(buffer)), StringSerializer.instance.read(buffer), Vector3.Serializer.read(buffer), buffer.func_150791_c(), PlayerHandle.Serializer.read(buffer));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                throw new RuntimeException("An exception occurred in PostTile Packet NBT decoding");
            }
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            boolean isClientSide = context.getDirection().getReceptionSide().isClient();
            TileEntityUtils.findTileEntity(message.info.dimensionKey, isClientSide, message.info.pos, PostTile.class).ifPresent(tile -> {
                Optional<BlockPartMetadata> meta = partsMetadata.stream().filter(m -> m.identifier.equals(message.partMetaIdentifier)).findFirst();
                if (meta.isPresent()) {
                    tile.addPart(message.info.identifier, new BlockPartInstance((BlockPart)meta.get().read(message.partData), message.offset), message.cost, message.player);
                    if (message.cost.func_190916_E() > 0 && (!isClientSide || SideUtils.getClientPlayer().map(player -> player.func_110124_au().equals(message.player.id)).orElse(false).booleanValue())) {
                        SideUtils.makePlayerPayIfEditor(isClientSide, (PlayerEntity)context.getSender(), message.player, message.cost);
                    }
                    tile.func_70296_d();
                } else {
                    Signpost.LOGGER.warn("Could not find meta for part " + message.partMetaIdentifier);
                }
            });
        }

        public static class Packet {
            public final TilePartInfo info;
            public final String partMetaIdentifier;
            public final CompoundNBT partData;
            public final Vector3 offset;
            public final ItemStack cost;
            public final PlayerHandle player;

            public Packet(TilePartInfo info, CompoundNBT partData, String partMetaIdentifier, Vector3 offset, ItemStack cost, PlayerHandle player) {
                this.info = info;
                this.partMetaIdentifier = partMetaIdentifier;
                this.partData = partData;
                this.offset = offset;
                this.cost = cost;
                this.player = player;
            }
        }
    }

    public static class TilePartInfo {
        public final ResourceLocation dimensionKey;
        public final BlockPos pos;
        public final UUID identifier;
        public static final CompoundSerializable<TilePartInfo> Serializer = new SerializerImpl();

        public TilePartInfo(TileEntity tile, UUID identifier) {
            this.dimensionKey = tile.func_145831_w().func_201675_m().func_186058_p().getRegistryName();
            this.pos = tile.func_174877_v();
            this.identifier = identifier;
        }

        public TilePartInfo(ResourceLocation dimensionKey, BlockPos pos, UUID identifier) {
            this.dimensionKey = dimensionKey;
            this.pos = pos;
            this.identifier = identifier;
        }

        public static final class SerializerImpl
        implements CompoundSerializable<TilePartInfo> {
            @Override
            public CompoundNBT write(TilePartInfo tilePartInfo, CompoundNBT compound) {
                compound.func_74778_a("Dimension", tilePartInfo.dimensionKey.toString());
                compound.func_218657_a("Pos", (INBT)BlockPosSerializer.INSTANCE.write(tilePartInfo.pos, compound));
                compound.func_218657_a("Id", (INBT)UuidSerializer.INSTANCE.write(tilePartInfo.identifier));
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundNBT compound) {
                return compound.func_74764_b("Dimension") && compound.func_74764_b("Pos") && compound.func_74764_b("Id");
            }

            @Override
            public TilePartInfo read(CompoundNBT compound) {
                return new TilePartInfo(new ResourceLocation(compound.func_74779_i("Dimension")), BlockPosSerializer.INSTANCE.read(compound.func_74775_l("Pos")), UuidSerializer.INSTANCE.read(compound.func_74775_l("Id")));
            }

            @Override
            public Class<TilePartInfo> getTargetClass() {
                return TilePartInfo.class;
            }

            @Override
            public void write(TilePartInfo tilePartInfo, PacketBuffer buffer) {
                buffer.func_192572_a(tilePartInfo.dimensionKey);
                BlockPosSerializer.INSTANCE.write(tilePartInfo.pos, buffer);
                UuidSerializer.INSTANCE.write(tilePartInfo.identifier, buffer);
            }

            @Override
            public TilePartInfo read(PacketBuffer buffer) {
                return new TilePartInfo(buffer.func_192575_l(), BlockPosSerializer.INSTANCE.read(buffer), UuidSerializer.INSTANCE.read(buffer));
            }
        }
    }

    public static class TraceResult {
        public final BlockPartInstance part;
        public final UUID id;
        public final Vector3 hitPos;
        public final Ray ray;

        public TraceResult(BlockPartInstance part, UUID id, Vector3 hitPos, Ray ray) {
            this.part = part;
            this.id = id;
            this.hitPos = hitPos;
            this.ray = ray;
        }
    }
}

