/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WaystoneTile
extends TileEntity
implements WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "waystone";
    public static final TileEntityType<WaystoneTile> type = TileEntityType.Builder.func_223042_a(WaystoneTile::new, (Block[])new Block[]{WaystoneBlock.INSTANCE}).func_206865_a(null);
    private Optional<PlayerHandle> owner = Optional.empty();

    public WaystoneTile() {
        super(type);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145830_o() && !this.func_145831_w().func_201670_d()) {
            Optional<WorldLocation> location = WorldLocation.from(this);
            if (location.isPresent()) {
                WaystoneLibrary.getInstance().removeAt(location.get(), PlayerHandle.Invalid);
            } else {
                Signpost.LOGGER.error("Waystone tile at " + this.func_174877_v() + "  was removed but world was null. This means that the waystone has not been cleaned up correctly.");
            }
        }
    }

    public void func_226984_a_(World world, BlockPos pos) {
        if (!world.func_201670_d()) {
            Optional<WorldLocation> oldLocation = WorldLocation.from(this);
            oldLocation.ifPresent(worldLocation -> WaystoneLibrary.getInstance().updateLocation((WorldLocation)worldLocation, new WorldLocation(pos, world)));
        }
        super.func_226984_a_(world, pos);
    }

    public void func_174878_a(BlockPos pos) {
        Optional<WorldLocation> oldLocation = WorldLocation.from(this);
        super.func_174878_a(pos);
        Optional<WorldLocation> newLocation = WorldLocation.from(this);
        if (oldLocation.isPresent() && newLocation.isPresent() && !this.func_145831_w().func_201670_d()) {
            WaystoneLibrary.getInstance().updateLocation(oldLocation.get(), newLocation.get());
        }
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("Owner", (INBT)PlayerHandle.Serializer.optional().write(this.owner));
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.owner = ((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.func_74775_l("Owner"));
    }
}

