/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.minecraft.config.Config;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class BlockRestrictions {
    public static final String commandName = "blockRestrictions";

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)commandName).then(BlockRestrictions.signposts())).then(BlockRestrictions.waystone());
    }

    private static ArgumentBuilder<CommandSource, ?> signposts() {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"signposts").then(BlockRestrictions.getter(BlockRestrictions.Type.Signpost))).then(BlockRestrictions.setter(BlockRestrictions.Type.Signpost));
    }

    private static ArgumentBuilder<CommandSource, ?> waystone() {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"waystone").then(BlockRestrictions.getter(BlockRestrictions.Type.Waystone))).then(BlockRestrictions.setter(BlockRestrictions.Type.Waystone));
    }

    private static ArgumentBuilder<CommandSource, ?> getter(BlockRestrictions.Type type) {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"get").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            return BlockRestrictions.get(type, (CommandSource)context.getSource(), (PlayerEntity)player);
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).requires(source -> source.func_197034_c(3))).executes(context -> BlockRestrictions.get(type, (CommandSource)context.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)"player"))));
    }

    private static int get(BlockRestrictions.Type type, CommandSource commandSource, PlayerEntity targetedPlayer) {
        int left = gollorum.signpost.BlockRestrictions.getInstance().getRemaining(type, PlayerHandle.from((Entity)targetedPlayer));
        Optional<ITextComponent> subject = PlayerHandle.from(commandSource.func_197022_f()).equals(PlayerHandle.from((Entity)targetedPlayer)) || targetedPlayer == null ? Optional.empty() : Optional.of(targetedPlayer.func_145748_c_());
        commandSource.func_197030_a((ITextComponent)(left < 0 ? type.getUnlimitedRemainingTextComponent(subject) : type.getRemainingTextComponent(left, subject)), false);
        return 1;
    }

    private static ArgumentBuilder<CommandSource, ?> setter(BlockRestrictions.Type type) {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"set").requires(source -> source.func_197034_c(((Integer)Config.Server.permissions.setBlockResPermissionLevel.get()).intValue()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            return BlockRestrictions.set(type, (CommandSource)context.getSource(), player, IntegerArgumentType.getInteger((CommandContext)context, (String)"count"));
        })).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> BlockRestrictions.set(type, (CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))));
    }

    private static int set(BlockRestrictions.Type type, CommandSource commandSource, ServerPlayerEntity targetedPlayer, int count) {
        PlayerHandle tHandle = PlayerHandle.from((Entity)targetedPlayer);
        gollorum.signpost.BlockRestrictions.getInstance().setRemaining(type, tHandle, c -> count);
        Optional<ITextComponent> subject = PlayerHandle.from(commandSource.func_197022_f()).equals(tHandle) || targetedPlayer == null ? Optional.empty() : Optional.of(targetedPlayer.func_145748_c_());
        commandSource.func_197030_a((ITextComponent)(count < 0 ? type.getUnlimitedRemainingTextComponent(subject) : type.getRemainingTextComponent(count, subject)), true);
        return 1;
    }
}

