/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.commands.WaystoneArgument;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.TextComponents;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DiscoverWaystone {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"discover").requires(source -> source.func_197034_c(((Integer)Config.Server.permissions.discoverPermissionLevel.get()).intValue()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"waystone", (ArgumentType)new WaystoneArgument()).requires(source -> {
            try {
                source.func_197035_h();
                return true;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(context -> DiscoverWaystone.execute((String)context.getArgument("waystone", String.class), ((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197056_a((String)"waystone", (ArgumentType)new WaystoneArgument()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> DiscoverWaystone.execute((String)context.getArgument("waystone", String.class), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))));
    }

    private static int execute(String name, ServerPlayerEntity player) throws CommandSyntaxException {
        WaystoneHandle.Vanilla handle = WaystoneLibrary.getInstance().getHandleByName(name).orElseThrow(() -> new SimpleCommandExceptionType((Message)new TranslationTextComponent("signpost.waystone_not_found", new Object[]{Colors.wrap(name, Colors.highlight)})).create());
        if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle((Entity)player), handle)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.discovered", new Object[]{TextComponents.waystone(player, name)}));
        }
        return 1;
    }
}

