/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.gui.utils.Colors;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.util.text.TranslationTextComponent;

public class WaystoneArgument
implements ArgumentType<String> {
    private static final Pattern nonLiteralPattern;

    public static void bootstrap() {
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        if (WaystoneLibrary.hasInstance() && WaystoneLibrary.getInstance().getAllWaystoneNames(false).map(n -> n.contains(name)).orElse(true).booleanValue()) {
            return name;
        }
        throw new SimpleCommandExceptionType((Message)new TranslationTextComponent("signpost.waystone_not_found", new Object[]{Colors.wrap(name, Colors.highlight)})).create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!WaystoneLibrary.hasInstance()) {
            return ISuggestionProvider.func_197005_b(new HashSet(), (SuggestionsBuilder)builder);
        }
        CompletableFuture<Suggestions> ret = new CompletableFuture<Suggestions>();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> ISuggestionProvider.func_197005_b((Iterable)names.values().stream().map(s -> nonLiteralPattern.matcher((CharSequence)s).find() ? "\"" + s + "\"" : s).collect(Collectors.toSet()), (SuggestionsBuilder)builder).thenAccept(ret::complete), Optional.empty(), Signpost.getServerType().isClient);
        return ret;
    }

    static {
        ArgumentTypes.func_218136_a((String)"signpost:waystone", WaystoneArgument.class, (IArgumentSerializer)new ArgumentSerializer(WaystoneArgument::new));
        nonLiteralPattern = Pattern.compile("[^a-z0-9]", 2);
    }
}

