/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CutWaystoneRecipe
extends StonecuttingRecipe {
    public static final String RegistryName = "cut_waystone";

    public CutWaystoneRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack result) {
        super(id, group, ingredient, result);
    }

    public boolean func_77569_a(IInventory inv, World world) {
        return super.func_77569_a(inv, world) && CutWaystoneRecipe.isAllowed(this.field_222132_b);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    private static boolean isAllowed(ItemStack result) {
        if (!(result.func_77973_b() instanceof BlockItem)) {
            return true;
        }
        Block block = ((BlockItem)result.func_77973_b()).func_179223_d();
        if (!(block instanceof ModelWaystone)) {
            return true;
        }
        return ((List)Config.Server.allowedWaystones.get()).contains(((ModelWaystone)block).variant.name);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CutWaystoneRecipe> {
        public static Serializer INSTANCE = new Serializer();

        public CutWaystoneRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            String resultLoc = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            int count = JSONUtils.func_151203_m((JsonObject)json, (String)"count");
            ItemStack result = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(resultLoc)), count);
            return CutWaystoneRecipe.isAllowed(result) ? new CutWaystoneRecipe(recipeId, group, ingredient, result) : null;
        }

        public CutWaystoneRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = StringSerializer.instance.read(buffer);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            return new CutWaystoneRecipe(recipeId, group, ingredient, result);
        }

        public void toNetwork(PacketBuffer buffer, CutWaystoneRecipe recipe) {
            StringSerializer.instance.write(recipe.field_222134_d, buffer);
            recipe.field_222131_a.func_199564_a(buffer);
            buffer.func_150788_a(recipe.field_222132_b);
        }
    }
}

