/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.functions.CopyNbt;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class LootTables
extends LootTableProvider {
    public LootTables(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> this::generateBlockLootTables, (Object)LootParameterSets.field_216267_h));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
    }

    private void generateBlockLootTables(BiConsumer<ResourceLocation, LootTable.Builder> builder) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            builder.accept(new ResourceLocation("signpost", "blocks/" + variant.block.getRegistryName().func_110623_a()), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)variant.block).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Parts", "Parts")).func_212840_b_(BlockLootTables.field_218573_a)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)variant.block)))));
        }
        builder.accept(new ResourceLocation("signpost", "blocks/" + WaystoneBlock.INSTANCE.getRegistryName().func_110623_a()), BlockLootTables.func_218463_a((IItemProvider)WaystoneBlock.INSTANCE, (IRandomRange)ConstantRange.func_215835_a((int)1)));
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            builder.accept(new ResourceLocation("signpost", "blocks/" + variant.block.getRegistryName().func_110623_a()), BlockLootTables.func_218463_a((IItemProvider)variant.block, (IRandomRange)ConstantRange.func_215835_a((int)1)));
        }
    }
}

