/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import gollorum.signpost.minecraft.block.ModelWaystone;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;

public class WaystoneModel
extends BlockModelProvider {
    public final BlockModelBuilder waystoneModel;
    public static final ResourceLocation inPostLocation = new ResourceLocation("signpost", "block/in_post_waystone");
    public final Map<ModelWaystone.Variant, ModelFile> variantModels = new HashMap<ModelWaystone.Variant, ModelFile>();

    public static WaystoneModel addTo(DataGenerator generator, ExistingFileHelper fileHelper) {
        WaystoneModel self = new WaystoneModel(generator, fileHelper);
        generator.func_200390_a((IDataProvider)self);
        generator.func_200390_a(self.makeItem(generator, fileHelper));
        return self;
    }

    private WaystoneModel(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "signpost", fileHelper);
        this.waystoneModel = new BlockModelBuilder(new ResourceLocation("signpost", "block/waystone"), fileHelper);
    }

    protected void registerModels() {
        ResourceLocation waystoneTexture = new ResourceLocation("signpost", "block/waystone");
        this.cubeAll("waystone", waystoneTexture);
        ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(inPostLocation.toString())).element().from(-3.0f, 0.0f, -3.0f).to(3.0f, 6.0f, 3.0f).allFaces((dir, builder) -> builder.texture("#texture").uvs(5.0f, 5.0f, 11.0f, 11.0f)).end()).texture("texture", waystoneTexture);
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            ResourceLocation loc = new ResourceLocation("signpost", "block/" + variant.registryName);
            this.variantModels.put(variant, (ModelFile)new ModelFile.ExistingModelFile(loc, this.existingFileHelper));
        }
    }

    private IDataProvider makeItem(DataGenerator generator, ExistingFileHelper fileHelper) {
        return new Item(generator, fileHelper);
    }

    public String func_200397_b() {
        return "waystone model block";
    }

    private class Item
    extends ItemModelProvider {
        public Item(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "signpost", existingFileHelper);
        }

        protected void registerModels() {
            ((ItemModelBuilder)this.getBuilder("waystone")).parent((ModelFile)WaystoneModel.this.waystoneModel);
            for (Map.Entry<ModelWaystone.Variant, ModelFile> variant : WaystoneModel.this.variantModels.entrySet()) {
                ((ItemModelBuilder)this.getBuilder(variant.getKey().registryName)).parent(variant.getValue());
            }
        }

        public String func_200397_b() {
            return "waystone model item";
        }
    }
}

