/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.Teleport;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.SignGui;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.ExtendedScreen;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.GuiItemRenderer;
import gollorum.signpost.minecraft.gui.widgets.ImageView;
import gollorum.signpost.minecraft.gui.widgets.TextDisplay;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfirmTeleportGui
extends ExtendedScreen {
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private static final int costCenterSpace = 10;
    private final Either<String, Teleport.RequestGui.Package.Info> data;
    private final Optional<SignInfo> signInfo;

    public ConfirmTeleportGui(Either<String, Teleport.RequestGui.Package.Info> data, Optional<SignInfo> signInfo) {
        super((ITextComponent)new TranslationTextComponent("gui.signpost.confirm_teleport_gui_title", new Object[0]));
        this.data = data;
        this.signInfo = signInfo;
    }

    public static void display(Either<String, Teleport.RequestGui.Package.Info> data, Optional<SignInfo> signInfo) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmTeleportGui(data, signInfo));
    }

    @Override
    protected void init() {
        super.init();
        AtomicInteger editButtonTop = new AtomicInteger();
        this.data.consume(langKey -> {
            this.additionalRenderables.add(new TextDisplay(new Point(this.width / 2, this.height / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font, (String)langKey, new Tuple[0]));
            editButtonTop.set(this.height / 2 + 20);
        }, d -> {
            boolean isTooFarAway;
            boolean bl = isTooFarAway = d.maxDistance > 0 && d.distance > d.maxDistance;
            if (d.isDiscovered && !isTooFarAway) {
                this.additionalRenderables.add(new TextDisplay(new Point(this.width / 2, this.height / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font, "gui.signpost.confirm_teleport", Tuple.of(d.waystoneName, Colors.highlight.func_211163_e())));
                if (!d.cost.func_190926_b()) {
                    this.additionalRenderables.add(new TextDisplay(new Point(this.width / 2 - 5, this.height / 2), Rect.XAlignment.Right, Rect.YAlignment.Center, this.font, "gui.signpost.cost", new Tuple[0]));
                    Rect itemRect = new Rect(new Point(this.width / 2 + 5, this.height / 2), TextureResource.itemBackground.size, Rect.XAlignment.Left, Rect.YAlignment.Center);
                    this.additionalRenderables.add(new ImageView(TextureResource.itemBackground, itemRect));
                    this.additionalRenderables.add(new GuiItemRenderer(new Rect(itemRect.center(), 16, 16, Rect.XAlignment.Center, Rect.YAlignment.Center), d.cost));
                }
                Rect confirmRect = new Rect(new Point(this.width / 2 + 20, this.height / 2 + 20), buttonsSize, Rect.XAlignment.Left, Rect.YAlignment.Top);
                Rect cancelRect = new Rect(new Point(this.width / 2 - 20, this.height / 2 + 20), buttonsSize, Rect.XAlignment.Right, Rect.YAlignment.Top);
                this.addButton((Widget)new Button(confirmRect.point.x, confirmRect.point.y, confirmRect.width, confirmRect.height, new TranslationTextComponent("gui.proceed", new Object[0]).getString(), b -> this.confirm()));
                this.addButton((Widget)new Button(cancelRect.point.x, cancelRect.point.y, cancelRect.width, cancelRect.height, new TranslationTextComponent("gui.cancel", new Object[0]).getString(), b -> this.cancel()));
                editButtonTop.set(cancelRect.max().y + 20);
            } else {
                if (!d.isDiscovered) {
                    this.additionalRenderables.add(new TextDisplay(new Point(this.width / 2, this.height / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font, "signpost.not_discovered", new Tuple<String, Integer>(d.waystoneName, Colors.highlight.func_211163_e())));
                }
                if (isTooFarAway) {
                    this.additionalRenderables.add(new TextDisplay(new Point(this.width / 2, this.height / 2 - (d.isDiscovered ? 20 : 40)), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font, "signpost.too_far_away", new Tuple<String, Integer>(Integer.toString(d.distance), Colors.highlight.func_211163_e()), new Tuple<String, Integer>(Integer.toString(d.maxDistance), Colors.highlight.func_211163_e())));
                }
                editButtonTop.set(this.height / 2 + 20);
            }
        });
        this.signInfo.ifPresent(info -> {
            Rect editRect = new Rect(new Point(this.width / 2, editButtonTop.get()), TextureResource.edit.size, Rect.XAlignment.Center, Rect.YAlignment.Top);
            if (info.sign.hasThePermissionToEdit(info.tile, (PlayerEntity)this.getMinecraft().field_71439_g)) {
                this.addButton((Widget)new ImageButton(editRect.point.x, editRect.point.y, editRect.width, editRect.height, 0, 0, TextureResource.edit.size.height, TextureResource.edit.location, TextureResource.edit.fileSize.width, TextureResource.edit.fileSize.height, b -> SignGui.display(info.tile, info.sign, info.offset, info.tilePartInfo)));
            }
        });
    }

    private void confirm() {
        this.getMinecraft().func_147108_a(null);
        this.data.consume(langKey -> this.getMinecraft().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent(langKey, new Object[0]), true), data -> PacketHandler.sendToServer(new Teleport.Request.Package(data.waystoneName)));
    }

    private void cancel() {
        this.getMinecraft().func_147108_a(null);
    }

    public static class SignInfo {
        public final PostTile tile;
        public final SignBlockPart sign;
        public final PostTile.TilePartInfo tilePartInfo;
        public final Vector3 offset;

        public SignInfo(PostTile tile, SignBlockPart sign, PostTile.TilePartInfo tilePartInfo, Vector3 offset) {
            this.tile = tile;
            this.sign = sign;
            this.tilePartInfo = tilePartInfo;
            this.offset = offset;
        }
    }
}

