/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import com.google.common.collect.Streams;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.ExtendedScreen;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.widgets.GuiBlockPartRenderer;
import gollorum.signpost.minecraft.gui.widgets.ItemButton;
import gollorum.signpost.minecraft.gui.widgets.SpriteSelectionButton;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.Angle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class PaintBlockPartGui<T extends BlockPart<T>>
extends ExtendedScreen {
    private final PostTile tile;
    private final int maxBlocksPerRow = 9;
    private List<SpriteSelectionButton> textureButtons = new ArrayList<SpriteSelectionButton>();
    protected final T part;
    protected final T displayPart;
    protected TextureAtlasSprite oldSprite;
    private final UUID identifier;
    private Function<ResourceLocation, TextureAtlasSprite> atlasSpriteGetter;
    private static final Direction[] faces = new Direction[]{null, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};

    public PaintBlockPartGui(PostTile tile, T part, T displayPart, UUID identifier, ResourceLocation oldTexture) {
        super((ITextComponent)new StringTextComponent("Paint Post"));
        this.tile = tile;
        this.part = part;
        this.displayPart = displayPart;
        this.atlasSpriteGetter = Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_);
        this.oldSprite = this.spriteFrom(oldTexture);
        this.identifier = identifier;
    }

    protected TextureAtlasSprite spriteFrom(ResourceLocation loc) {
        return this.atlasSpriteGetter.apply(loc);
    }

    @Override
    protected void init() {
        super.init();
        List blocksToRender = this.getMinecraft().field_71439_g.field_71071_by.field_70462_a.stream().filter(i -> !i.func_190926_b() && (i.func_77973_b() instanceof BlockItem || i.func_77973_b() instanceof BucketItem)).map(i -> {
            ItemStack ret = i.func_77946_l();
            ret.func_190920_e(1);
            return ret;
        }).distinct().map(is -> Tuple.of(this.allSpritesFor((ItemStack)is), is)).filter(p -> ((List)p._1).size() > 0).collect(Collectors.toList());
        int rows = (blocksToRender.size() + 8) / 9;
        for (int y = 0; y < rows; ++y) {
            int rowWidth = y == rows - 1 ? (blocksToRender.size() - 1) % 9 + 1 : 9;
            int top = this.height * 3 / 4 + y * 20;
            int left = this.width / 2 - rowWidth * 20 / 2;
            for (int x = 0; x < rowWidth; ++x) {
                Tuple tuple = (Tuple)blocksToRender.get(x + y * 9);
                this.addButton((Widget)new ItemButton(left + x * 20, top, Rect.XAlignment.Left, Rect.YAlignment.Bottom, (ItemStack)tuple._2, b -> this.setupTextureButtonsFor((List)tuple._1), this.itemRenderer, this.font));
            }
        }
        this.addButton(new GuiBlockPartRenderer(this.tile.getParts().stream().map(p -> p.blockPart == this.part ? new BlockPartInstance((BlockPart)this.displayPart, p.offset) : p).collect(Collectors.toList()), new Point(this.width / 2, this.height / 4), Angle.fromDegrees(this.getMinecraft().field_71439_g.field_70177_z + 180.0f), Angle.fromDegrees(this.getMinecraft().field_71439_g.field_70125_A), 64.0f));
    }

    private List<TextureAtlasSprite> allSpritesFor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            return this.allSpritesFor((BlockItem)item, stack);
        }
        if (item instanceof BucketItem) {
            return this.allSpritesFor((BucketItem)item);
        }
        throw new RuntimeException("Item type of " + item.getClass() + " not supported");
    }

    private List<TextureAtlasSprite> allSpritesFor(BlockItem item, ItemStack stack) {
        Block block = item.func_179223_d();
        return block instanceof PostBlock && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Parts") ? PostTile.readPartInstances(stack.func_77978_p().func_74775_l("Parts")).stream().flatMap(i -> i.blockPart.getAllTextures().stream().map(this::spriteFrom)).collect(Collectors.toList()) : this.allSpritesFor(block.func_176223_P());
    }

    private List<TextureAtlasSprite> allSpritesFor(BucketItem item) {
        return item.getFluid().getAttributes().getTextures().map(this::spriteFrom).collect(Collectors.toList());
    }

    private List<TextureAtlasSprite> allSpritesFor(BlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        return Arrays.stream(faces).flatMap(side -> model.func_200117_a(null, side, this.font.field_78289_c).stream()).map(BakedQuad::func_187508_a).distinct().collect(Collectors.toList());
    }

    private void setupTextureButtonsFor(List<TextureAtlasSprite> sprites) {
        this.clearSelection();
        sprites = Streams.concat((Stream[])new Stream[]{Stream.of(this.oldSprite), sprites.stream()}).distinct().collect(Collectors.toList());
        int spriteButtonSize = 30;
        int centerY = this.height / 2 + 10;
        int left = this.width / 2 - sprites.size() * spriteButtonSize / 2;
        for (int x = 0; x < sprites.size(); ++x) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)sprites.get(x);
            SpriteSelectionButton newButton = new SpriteSelectionButton(new Rect(new Point(left + x * spriteButtonSize, centerY), spriteButtonSize, spriteButtonSize, Rect.XAlignment.Left, Rect.YAlignment.Center), sprite, imgButton -> this.setTexture(this.displayPart, sprite.func_195668_m()));
            this.addButton((Widget)newButton);
            this.textureButtons.add(newButton);
        }
    }

    protected void clearSelection() {
        this.removeButtons(this.textureButtons);
    }

    protected abstract void setTexture(T var1, ResourceLocation var2);

    public void onClose() {
        super.onClose();
        PacketHandler.sendToServer(new PostTile.PartMutatedEvent.Packet(new PostTile.TilePartInfo(this.tile, this.identifier), this.part.getMeta().write(this.displayPart), this.part.getMeta().identifier));
    }
}

