/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.PaintBlockPartGui;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class PaintSignGui<T extends SignBlockPart<T>>
extends PaintBlockPartGui<T> {
    private final TextureAtlasSprite oldMainSprite;
    private final TextureAtlasSprite oldSecSprite;
    private boolean isTargetingMainTexture;

    public PaintSignGui(PostTile tile, T sign, UUID identifier) {
        super(tile, sign, ((SignBlockPart)sign).copy(), identifier, ((SignBlockPart)sign).getMainTexture());
        this.oldMainSprite = this.oldSprite;
        this.oldSecSprite = this.spriteFrom(((SignBlockPart)sign).getSecondaryTexture());
        this.isTargetingMainTexture = true;
    }

    public static <T extends SignBlockPart<T>> void display(PostTile tile, T sign, UUID identifier) {
        Minecraft.func_71410_x().func_147108_a(new PaintSignGui<T>(tile, sign, identifier));
    }

    @Override
    protected void init() {
        super.init();
        Rect buttonRect = new Rect(new Point(this.width / 4, this.height / 4), 125, 20, Rect.XAlignment.Center, Rect.YAlignment.Center);
        this.addButton((Widget)new Button(buttonRect.point.x, buttonRect.point.y, buttonRect.width, buttonRect.height, new TranslationTextComponent(this.isTargetingMainTexture ? "gui.signpost.main_material" : "gui.signpost.secondary_material", new Object[0]).getString(), b -> {
            this.isTargetingMainTexture = !this.isTargetingMainTexture;
            this.oldSprite = this.isTargetingMainTexture ? this.oldMainSprite : this.oldSecSprite;
            this.clearSelection();
            b.setMessage(new TranslationTextComponent(this.isTargetingMainTexture ? "gui.signpost.main_material" : "gui.signpost.secondary_material", new Object[0]).getString());
        }));
    }

    @Override
    protected void setTexture(T sign, ResourceLocation texture) {
        if (this.isTargetingMainTexture) {
            ((SignBlockPart)sign).setMainTexture(texture);
        } else {
            ((SignBlockPart)sign).setSecondaryTexture(texture);
        }
    }
}

