/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.events.WaystoneRenamedEvent;
import gollorum.signpost.minecraft.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.gui.utils.ExtendedScreen;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.ImageInputBox;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.LockIconButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WaystoneGui
extends ExtendedScreen {
    private final WorldLocation location;
    private final Optional<WaystoneData> oldData;
    private ImageInputBox inputBox;
    private Optional<Set<String>> allWaystoneNames = Optional.empty();
    private static final TextureResource texture = TextureResource.waystoneNameField;
    private static final int inputBoxScale = 3;
    private static final int inputBoxYOffset = -46;
    private static final int buttonsYOffset = 46;
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private LockIconButton lockButton;
    private Button doneButton;
    private final Consumer<WaystoneUpdatedEvent> waystoneUpdateListener = event -> this.allWaystoneNames.ifPresent(names -> {
        switch (event.getType()) {
            case Added: {
                names.add(event.name);
                break;
            }
            case Removed: {
                names.remove(event.name);
                break;
            }
            case Renamed: {
                names.remove(((WaystoneRenamedEvent)event).oldName);
                names.add(event.name);
            }
        }
    });

    public WaystoneGui(WorldLocation location, Optional<WaystoneData> oldData) {
        super((ITextComponent)new StringTextComponent("Waystone"));
        this.location = location;
        this.oldData = oldData;
    }

    public static void display(WorldLocation location, Optional<WaystoneData> oldData) {
        Minecraft.func_71410_x().func_147108_a((Screen)new WaystoneGui(location, oldData));
    }

    private int getCenterX() {
        return this.width / 2;
    }

    private int getCenterY() {
        return this.height / 2;
    }

    @Override
    protected void init() {
        super.init();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> {
            this.allWaystoneNames = Optional.of(new HashSet(names.values()));
        }, Optional.empty(), true);
        WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.waystoneUpdateListener);
        Point point = new Point(this.getCenterX(), this.getCenterY() + -46);
        int n = (WaystoneGui.texture.size.width - 6) * 3;
        this.font.getClass();
        this.inputBox = new ImageInputBox(this.font, new Rect(point, new TextureSize(n, 9), Rect.XAlignment.Center, Rect.YAlignment.Bottom), new Rect(Point.zero, WaystoneGui.texture.size.scale(3.0f), Rect.XAlignment.Center, Rect.YAlignment.Center), Rect.XAlignment.Center, Rect.YAlignment.Center, texture, true, 0.0);
        this.lockButton = new LockIconButton(this.inputBox.x + this.inputBox.width() + 10, this.inputBox.y + this.inputBox.getHeight() / 2 - 10, b -> this.lockButton.func_175229_b(!this.lockButton.func_175230_c()));
        this.addButton((Widget)this.lockButton);
        this.oldData.ifPresent(data -> {
            this.inputBox.setText(data.name);
            this.lockButton.func_175229_b(data.isLocked);
        });
        this.doneButton = new Button(this.getCenterX() - WaystoneGui.buttonsSize.width / 2, this.getCenterY() - WaystoneGui.buttonsSize.height / 2 + 46, WaystoneGui.buttonsSize.width, WaystoneGui.buttonsSize.height, new TranslationTextComponent("gui.done", new Object[0]).getString(), b -> this.done());
        this.addButton((Widget)this.inputBox);
        this.addButton((Widget)this.doneButton);
        this.inputBox.func_146193_g(0xFFFFFF);
        this.inputBox.func_146204_h(0xDDDDDD);
        this.inputBox.func_146203_f(200);
        this.inputBox.func_212954_a(name -> {
            if (this.isValid((String)name)) {
                this.inputBox.func_146193_g(0xFFFFFF);
                this.inputBox.func_146204_h(0xDDDDDD);
                this.doneButton.active = true;
            } else {
                this.inputBox.func_146193_g(0xFF4444);
                this.inputBox.func_146204_h(0xDD6666);
                this.doneButton.active = false;
            }
        });
        this.func_212928_a((IGuiEventListener)this.inputBox);
    }

    private boolean isValid(String name) {
        return this.allWaystoneNames.map(names -> !names.contains(name)).orElse(true) != false || this.oldData.isPresent() && this.oldData.get().name.equals(name);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        super.onClose();
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.waystoneUpdateListener);
    }

    private void done() {
        if (this.inputBox != null && !this.inputBox.getText().equals("") && this.isValid(this.inputBox.getText())) {
            WaystoneLibrary.getInstance().requestUpdate(this.inputBox.getText(), new WaystoneLocationData(this.location, Vector3.fromVec3d(this.getMinecraft().field_71439_g.func_213303_ch())), this.lockButton.func_175230_c());
        }
        this.onClose();
    }
}

