/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.utils;

import com.google.common.collect.Streams;
import gollorum.signpost.minecraft.gui.utils.Ticking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;

public abstract class ExtendedScreen
extends Screen {
    protected final List<IRenderable> additionalRenderables = new ArrayList<IRenderable>();

    protected ExtendedScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        for (IRenderable toRender : this.additionalRenderables) {
            toRender.render(mouseX, mouseY, partialTicks);
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    protected void addButtons(Collection<? extends Widget> widgets) {
        this.buttons.addAll(widgets);
        this.children.addAll(widgets);
    }

    protected void removeButtons(Collection<? extends Widget> widgets) {
        this.buttons.removeAll(widgets);
        this.children.removeAll(widgets);
    }

    protected void removeButton(Widget widget) {
        this.buttons.remove(widget);
        this.children.remove(widget);
    }

    public void tick() {
        super.tick();
        Streams.concat((Stream[])new Stream[]{this.children.stream().map(c -> c), this.additionalRenderables.stream().map(a -> a)}).filter(o -> o instanceof Ticking).map(o -> (Ticking)o).forEach(Ticking::doTick);
    }

    public void setFocused(@Nullable IGuiEventListener listener) {
        Widget oldListener;
        if (this.getFocused() != listener && this.getFocused() instanceof Widget && (oldListener = (Widget)this.getFocused()).isFocused()) {
            oldListener.changeFocus(false);
        }
        super.setFocused(listener);
    }

    protected void init() {
        super.init();
        this.additionalRenderables.clear();
    }
}

