/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import gollorum.signpost.utils.math.Angle;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;

public class AngleInputBox
extends InputBox {
    public static final String degreeSign = Character.toString('\u00b0');
    @Nullable
    private Consumer<Angle> responder;
    private float currentResult;

    public AngleInputBox(FontRenderer fontRenderer, Rect inputFieldRect, double zOffset) {
        super(fontRenderer, new Rect(new Point(inputFieldRect.point.x + inputFieldRect.height, inputFieldRect.point.y), inputFieldRect.width - inputFieldRect.height, inputFieldRect.height), true, true, zOffset);
        this.func_200675_a(null);
        this.func_146180_a("0" + degreeSign);
        this.func_212954_a(null);
    }

    private static boolean isValidValue(String text) {
        return text.endsWith(degreeSign) ? AngleInputBox.canParse(text.substring(0, text.length() - 1)) : AngleInputBox.canParse(text);
    }

    private static boolean canParse(String text) {
        if (text.equals("")) {
            return true;
        }
        if (text.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private float getResult() {
        String text = this.func_146179_b().endsWith(degreeSign) ? this.func_146179_b().substring(0, this.func_146179_b().length() - 1) : this.func_146179_b();
        return text.equals("") || text.equals("-") ? 0.0f : (float)Integer.parseInt(text);
    }

    public Angle getCurrentAngle() {
        return Angle.fromDegrees(this.currentResult);
    }

    public void func_212954_a(@Nullable Consumer<String> responder) {
        super.func_212954_a(value -> {
            this.currentResult = this.getResult();
            if (responder != null) {
                responder.accept((String)value);
            }
        });
    }

    public void func_200675_a(@Nullable Predicate<String> filter) {
        super.func_200675_a(value -> AngleInputBox.isValidValue(value) && (filter == null || filter.test((String)value)));
    }

    public void setAngleResponder(@Nullable Consumer<Angle> responder) {
        this.func_212954_a(responder == null ? null : value -> responder.accept(Angle.fromDegrees(this.currentResult)));
    }

    public void setSelectedAngle(Angle angle) {
        this.func_146180_a(Math.round(angle.degrees()) + degreeSign);
    }
}

