/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class ColorInputBox
extends InputBox {
    private int currentResult;

    public ColorInputBox(FontRenderer fontRenderer, Rect inputFieldRect, double zOffset) {
        super(fontRenderer, new Rect(new Point(inputFieldRect.point.x + inputFieldRect.height, inputFieldRect.point.y), inputFieldRect.width - inputFieldRect.height, inputFieldRect.height), true, true, zOffset);
        this.func_200675_a(null);
        this.func_212954_a(null);
        this.func_146180_a("#000000");
    }

    private static boolean isValidColor(String text) {
        return text.startsWith("#") && text.length() <= 7 && ColorInputBox.canParse(text.substring(1));
    }

    public void func_200675_a(@Nullable Predicate<String> filter) {
        super.func_200675_a(text -> ColorInputBox.isValidColor(text) && (filter == null || filter.test((String)text)));
    }

    private static boolean canParse(String text) {
        if (text.equals("")) {
            return true;
        }
        try {
            Integer.parseInt(text, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int getResult() {
        if (this.func_146179_b().equals("#")) {
            return 0;
        }
        return Integer.parseInt(this.func_146179_b().substring(1), 16);
    }

    public int getCurrentColor() {
        return this.currentResult;
    }

    public void func_212954_a(@Nullable Consumer<String> responder) {
        super.func_212954_a(text -> {
            this.currentResult = this.getResult();
            if (responder != null) {
                responder.accept((String)text);
            }
        });
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResource.background.location);
        int red = Colors.getRed(this.currentResult);
        int green = Colors.getGreen(this.currentResult);
        int blue = Colors.getBlue(this.currentResult);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_((double)(this.x - this.height), (double)(this.y + this.height), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.x, (double)(this.y + this.height), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.x, (double)this.y, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)(this.x - this.height), (double)this.y, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(red, green, blue, 255).func_181675_d();
        tessellator.func_78381_a();
        super.renderButton(mouseX, mouseY, partialTicks);
    }

    public void setColorResponder(@Nullable Consumer<Integer> responder) {
        this.func_212954_a(text -> {
            if (responder != null) {
                responder.accept(this.currentResult);
            }
        });
    }

    public void setSelectedColor(int color) {
        String text = Integer.toHexString(color);
        if (text.length() < 6) {
            text = String.join((CharSequence)"", Collections.nCopies(6 - text.length(), "0")) + text;
        }
        this.func_146180_a("#" + text);
    }
}

