/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.DropDownSelection;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class DropDownSelection<EntryType>
extends ImageButton {
    public final Rect rect;
    private static final TextureResource texture = TextureResource.expandContract;
    public static final TextureSize size = new TextureSize(11, 11);
    private final Consumer<List> onShow;
    private final Consumer<List> onHide;
    private final Consumer<EntryType> onSelectionChanged;
    private final FontRenderer fontRenderer;
    private boolean isListVisible;
    private final List list;
    private final java.util.List<EntryType> allEntries = new ArrayList<EntryType>();
    private Predicate<EntryType> filter = b -> true;
    private int selectedIndex;
    private final boolean shouldHighlightSelected;

    public Collection<EntryType> getAllEntries() {
        return this.allEntries;
    }

    public Optional<EntryType> getSelectedEntry() {
        List.Entry selectedEntry = (List.Entry)this.list.getSelected();
        if (selectedEntry == null) {
            return Optional.empty();
        }
        return Optional.of(selectedEntry.content);
    }

    public void setFilter(Predicate<EntryType> filter) {
        this.filter = filter;
        this.list.updateContent();
    }

    public DropDownSelection(FontRenderer fontRenderer, Point position, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged, boolean shouldHighlightSelected) {
        this(fontRenderer, new Rect(position, size, xAlignment, yAlignment), width, height, yOffset, onShow, onHide, onSelectionChanged, shouldHighlightSelected);
    }

    private DropDownSelection(FontRenderer fontRenderer, Rect rect, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged, boolean shouldHighlightSelected) {
        super(rect.point.x, rect.point.y, rect.width, rect.height, 0, 0, DropDownSelection.texture.size.height, DropDownSelection.texture.location, DropDownSelection.texture.fileSize.width, DropDownSelection.texture.fileSize.height, b -> ((DropDownSelection)b).toggle());
        this.rect = rect;
        this.fontRenderer = fontRenderer;
        this.shouldHighlightSelected = shouldHighlightSelected;
        this.list = new List(this, Minecraft.func_71410_x(), new Point(rect.point.x + DropDownSelection.size.width, rect.point.y + DropDownSelection.size.height + yOffset), width, height);
        this.onSelectionChanged = onSelectionChanged;
        this.onShow = onShow;
        this.onHide = onHide;
    }

    public void addEntry(EntryType text) {
        if (!this.allEntries.contains(text)) {
            this.allEntries.add(text);
            this.list.updateContent();
        }
    }

    public void removeEntry(EntryType text) {
        if (this.allEntries.contains(text)) {
            this.allEntries.remove(text);
            this.list.updateContent();
        }
    }

    public void setEntries(Collection<EntryType> entries) {
        this.allEntries.clear();
        this.addEntries(entries);
    }

    public void addEntries(Collection<EntryType> entries) {
        this.allEntries.addAll(entries);
        this.list.updateContent();
    }

    public void toggle() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        } else {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void showList() {
        if (!this.isListVisible) {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void hideList() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.isListVisible) {
            this.list.render(mouseX, mouseY, partialTicks);
        }
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(DropDownSelection.texture.location);
        RenderSystem.disableDepthTest();
        int yTexStart = this.isHovered() ? DropDownSelection.texture.size.height : 0;
        int xTexStart = this.isListVisible ? DropDownSelection.texture.size.width : 0;
        DropDownSelection.blit((int)this.x, (int)this.y, (int)100, (float)xTexStart, (float)yTexStart, (int)this.width, (int)this.height, (int)DropDownSelection.texture.fileSize.height, (int)DropDownSelection.texture.fileSize.width);
        RenderSystem.enableDepthTest();
    }

    public class List
    extends ExtendedList<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
        private final int rimHeight;
        final /* synthetic */ DropDownSelection this$0;

        public List(DropDownSelection this$0, Minecraft minecraft, Point topRight, int width, int height) {
            minecraft.field_71466_p.getClass();
            this(this$0, minecraft, topRight, width, height, 9);
        }

        public List(DropDownSelection this$0, Minecraft minecraft, Point topRight, int width, int height, int rimHeight) {
            this.this$0 = this$0;
            super(minecraft, width, height, topRight.y + rimHeight, topRight.y + height - rimHeight, 14);
            this.x0 = topRight.x - width;
            this.x1 = topRight.x;
            this.setRenderHeader(false, 0);
            this.rimHeight = rimHeight;
            this.updateContent();
        }

        public void updateContent() {
            this.replaceEntries(this.this$0.allEntries.stream().filter(this.this$0.filter).map(x$0 -> new Entry(x$0)).collect(Collectors.toList()));
            this.setScrollAmount(this.getScrollAmount());
        }

        public int getRowWidth() {
            return this.width;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            int i = this.getScrollbarPosition();
            int j = i + 6;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            this.minecraft.func_110434_K().func_110577_a(TextureResource.background.location);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int backgroundBrightness = 170;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).func_181675_d();
            tessellator.func_78381_a();
            int k = this.getRowLeft();
            int l = this.y0 + 4 - (int)this.getScrollAmount();
            this.renderList(k, l, mouseX, mouseY, partialTicks);
            RenderSystem.disableDepthTest();
            this.renderStripe(new Point(this.x0 - 2, this.y0 - this.rimHeight), new Point(this.x0, this.y1 + this.rimHeight));
            this.renderStripe(new Point(this.x0, this.y0 - this.rimHeight), new Point(this.x1, this.y0));
            this.renderStripe(new Point(this.x0, this.y1), new Point(this.x1, this.y1 + this.rimHeight));
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.x0, (double)(this.y0 + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)(this.y0 + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)(this.y1 - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x0, (double)(this.y1 - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            int j1 = Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
            if (j1 > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
                int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.renderDecorations(mouseX, mouseY);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
        }

        protected void renderStripe(Point min, Point max) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            this.minecraft.func_110434_K().func_110577_a(TextureResource.background.location);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)min.x, (double)max.y, 0.0).func_225583_a_((float)min.x / 32.0f, (float)max.y / 32.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)max.x, (double)max.y, 0.0).func_225583_a_((float)max.x / 32.0f, (float)max.y / 32.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)max.x, (double)min.y, 0.0).func_225583_a_((float)max.x / 32.0f, (float)min.y / 32.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)min.x, (double)min.y, 0.0).func_225583_a_((float)min.x / 32.0f, (float)min.y / 32.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
        }

        protected void renderList(int p_renderList_1_, int p_renderList_2_, int mouseX, int mouseY, float p_renderList_5_) {
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                int rowTop = this.getRowTop(i);
                this.this$0.fontRenderer.getClass();
                int rowBottom = rowTop + 9;
                if (rowBottom < this.y0 || rowTop > this.y1) continue;
                int height = this.itemHeight - 4;
                Entry e = (Entry)this.getEntry(i);
                int width = this.getRowWidth();
                int left = this.getRowLeft();
                e.render(i, rowTop, left, width, height, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals(this.getEntryAtPosition(mouseX, mouseY), (Object)e), p_renderList_5_);
            }
        }

        protected int getScrollbarPosition() {
            return this.x1 - 6;
        }

        public class Entry
        extends ExtendedList.AbstractListEntry<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
            private final EntryType content;

            public Entry(EntryType content) {
                this.content = content;
            }

            public void render(int i, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
                int brightness = 255;
                if (this.isMouseOver(mouseX, mouseY)) {
                    brightness = (int)((float)brightness * 0.8f);
                }
                if (List.this.this$0.shouldHighlightSelected && List.this.this$0.allEntries.indexOf(((Entry)((List)List.this).getEntry((int)i)).content) == List.this.this$0.selectedIndex) {
                    brightness = (int)((float)brightness * 0.6f);
                }
                RenderSystem.enableAlphaTest();
                RenderingUtil.drawString(List.this.this$0.fontRenderer, this.content.toString(), new Point(List.this.x0, p_render_2_ + 1), Rect.XAlignment.Center, Rect.YAlignment.Top, Colors.from(brightness, brightness, brightness), List.this.width - 6, true);
            }

            public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                List.this.this$0.selectedIndex = List.this.this$0.allEntries.indexOf(this.content);
                List.this.this$0.onSelectionChanged.accept(this.content);
                return true;
            }
        }
    }
}

