/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.math.Angle;
import java.util.Collection;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.widget.Widget;

public class GuiBlockPartRenderer
extends Widget
implements IRenderable {
    private final Collection<BlockPartInstance> partsToRender;
    private final Point center;
    private Angle yaw;
    private Angle pitch;
    private float scale;

    public GuiBlockPartRenderer(Collection<BlockPartInstance> partsToRender, Point center, Angle yaw, Angle pitch, float scale) {
        super(center.x - GuiBlockPartRenderer.widthFor(scale) / 2, center.y - GuiBlockPartRenderer.heightFor(scale) / 2, GuiBlockPartRenderer.widthFor(scale), GuiBlockPartRenderer.heightFor(scale), "");
        this.partsToRender = partsToRender;
        this.center = center;
        this.yaw = yaw;
        this.pitch = pitch;
        this.scale = scale;
    }

    private static int widthFor(float scale) {
        return (int)(scale * 1.5f);
    }

    private static int heightFor(float scale) {
        return (int)(scale * 1.5f);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.isHovered()) {
            AbstractGui.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x20FFFFFF);
        }
        MatrixStack ms = new MatrixStack();
        RenderingUtil.wrapInMatrixEntry(ms, () -> {
            ms.func_227861_a_(0.0, 0.0, 100.0);
            for (BlockPartInstance bpi : this.partsToRender) {
                BlockPartRenderer.renderGuiDynamic(bpi.blockPart, ms, this.center, this.yaw, this.pitch, false, this.scale, bpi.offset.withY(y -> Float.valueOf(y.floatValue() - 0.5f)));
            }
        });
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.yaw = this.yaw.add(Angle.fromDegrees((float)(dragX * 3.0)));
        this.pitch = this.pitch.add(Angle.fromDegrees((float)(dragY * 3.0)));
    }
}

