/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;

public class GuiModelRenderer
implements IRenderable,
Flippable {
    private final FlippableModel model;
    private final float modelSpaceXOffset;
    private final float modelSpaceYOffset;
    private boolean isFlipped = false;
    private final Point center;
    private final int width;
    private final int height;
    public final Rect rect;
    private final RenderType renderType;
    private final int color;

    public GuiModelRenderer(Rect rect, FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, RenderType renderType) {
        this(rect, model, modelSpaceXOffset, modelSpaceYOffset, renderType, 0xFFFFFF);
    }

    public GuiModelRenderer(Rect rect, FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, RenderType renderType, int color) {
        this.rect = rect;
        this.center = rect.center();
        this.width = rect.width;
        this.height = rect.height;
        this.model = model;
        this.modelSpaceXOffset = modelSpaceXOffset;
        this.modelSpaceYOffset = modelSpaceYOffset;
        this.renderType = renderType;
        this.color = color;
    }

    @Override
    public boolean isFlipped() {
        return this.isFlipped;
    }

    @Override
    public void setFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        float scale = Math.min(this.width, this.height);
        MatrixStack matrixStack = new MatrixStack();
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.func_227861_a_(0.0, 0.0, -10.0);
            if (this.isFlipped) {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.PI));
            }
            RenderingUtil.renderGui(this.model.get(this.isFlipped), new MatrixStack(), this.color, this.center, Angle.ZERO, Angle.ZERO, this.isFlipped, scale, new Vector3(this.modelSpaceXOffset, this.modelSpaceYOffset, 0.0f), this.renderType, m -> {});
        });
    }
}

