/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public final class ImageInputBox
extends InputBox
implements Flippable {
    private final TextureResource texture;
    private Rect backgroundRect;
    public final Rect bounds;
    private boolean isFlipped = false;

    public ImageInputBox(FontRenderer fontRenderer, Rect inputFieldRect, Rect backgroundRect, Rect.XAlignment backXAlignment, Rect.YAlignment backYAlignment, TextureResource texture, boolean shouldDropShadow, double zOffset) {
        super(fontRenderer, inputFieldRect, shouldDropShadow, false, zOffset);
        this.texture = texture;
        this.func_146193_g(0);
        int x = backgroundRect.point.x + inputFieldRect.point.x;
        switch (backXAlignment) {
            case Center: {
                x += inputFieldRect.width / 2;
                break;
            }
            case Right: {
                x += inputFieldRect.width;
            }
        }
        int y = backgroundRect.point.y + inputFieldRect.point.y;
        switch (backYAlignment) {
            case Center: {
                y += inputFieldRect.height / 2;
                break;
            }
            case Bottom: {
                y += inputFieldRect.height;
            }
        }
        this.backgroundRect = new Rect(new Point(x, y), backgroundRect.width, backgroundRect.height);
        this.bounds = new Rect(Point.min(inputFieldRect.min(), this.backgroundRect.min()), Point.max(inputFieldRect.max(), this.backgroundRect.max()));
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture.location);
        ImageInputBox.blit((int)this.backgroundRect.point.x, (int)this.backgroundRect.point.y, (float)0.0f, (float)0.0f, (int)this.backgroundRect.width, (int)this.backgroundRect.height, (int)(this.isFlipped ? -this.backgroundRect.width : this.backgroundRect.width), (int)this.backgroundRect.height);
        super.renderButton(mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean isFlipped() {
        return this.isFlipped;
    }

    @Override
    public void setFlipped(boolean isFlipped) {
        if (isFlipped != this.isFlipped) {
            this.backgroundRect = this.backgroundRect.withPoint(p -> p.withX(oldX -> this.x + (this.x + this.width) - (this.backgroundRect.point.x + this.backgroundRect.width)));
        }
        this.isFlipped = isFlipped;
    }
}

