/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.minecraft.gui.utils.ConfigurableFont;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.Ticking;
import gollorum.signpost.minecraft.gui.utils.WithMutableX;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.Matrix4f;

public class InputBox
extends TextFieldWidget
implements WithMutableX,
Ticking {
    private boolean shouldDropShadow;
    private final ConfigurableFont configFont;
    private final List<Function<Integer, Boolean>> keyCodeConsumers = new ArrayList<Function<Integer, Boolean>>();
    private final double zOffset;

    public InputBox(FontRenderer configFont, Rect inputFieldRect, boolean shouldDropShadow, boolean shouldRenderBackGround, double zOffset) {
        this(new ConfigurableFont(configFont, !shouldDropShadow), inputFieldRect, shouldDropShadow, shouldRenderBackGround, zOffset);
    }

    private InputBox(ConfigurableFont configFont, Rect inputFieldRect, boolean shouldDropShadow, boolean shouldRenderBackGround, double zOffset) {
        super((FontRenderer)configFont, inputFieldRect.point.x, inputFieldRect.point.y, inputFieldRect.width, inputFieldRect.height, "");
        this.configFont = configFont;
        this.shouldDropShadow = shouldDropShadow;
        this.zOffset = zOffset;
        this.func_146185_a(shouldRenderBackGround);
    }

    @Override
    public void doTick() {
        super.func_146178_a();
    }

    public boolean shouldDropShadow() {
        return this.shouldDropShadow;
    }

    public void setShouldDropShadow(boolean shouldDropShadow) {
        this.shouldDropShadow = shouldDropShadow;
        this.configFont.setShouldProhibitShadows(!shouldDropShadow);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (Function<Integer, Boolean> consumer : this.keyCodeConsumers) {
            if (!consumer.apply(keyCode).booleanValue()) continue;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void addKeyCodeListener(int keyCode, Runnable action) {
        this.keyCodeConsumers.add(i -> {
            if (i == keyCode) {
                action.run();
                return true;
            }
            return false;
        });
    }

    public void renderButton(int p_94161_, int p_94162_, float p_94163_) {
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, this.zOffset);
        if (this.isHovered() && !this.func_146181_i()) {
            ((Object)((Object)this.configFont)).getClass();
            int fromY = this.y + (9 - this.height) / 2;
            AbstractGui.fill((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)this.x, (int)fromY, (int)(this.x + this.width), (int)(fromY + this.height), (int)0x40FFFFFF);
        }
        super.renderButton(p_94161_, p_94162_, p_94163_);
        matrixStack.func_227865_b_();
    }

    public void func_146185_a(boolean shouldBeBordered) {
        super.func_146185_a(shouldBeBordered);
        this.y = !shouldBeBordered ? (this.y += (this.height - 8) / 2) : (this.y -= (this.height - 8) / 2);
    }

    public String getText() {
        return this.func_146179_b();
    }

    public void setText(String txt) {
        this.func_146180_a(txt);
    }

    @Override
    public int getXPos() {
        return this.x;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public void setXPos(int x) {
        this.x = x;
    }
}

