/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.utils.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.text.TranslationTextComponent;

public class TextDisplay
implements IRenderable {
    private final List<Tuple<String, Integer>> texts;
    private final List<Integer> widths;
    public final Rect rect;
    private final FontRenderer fontRenderer;

    public TextDisplay(Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, FontRenderer fontRenderer, String translationKey, Tuple<String, Integer> ... args) {
        this(TextDisplay.getTextsFor(translationKey, args), point, xAlignment, yAlignment, fontRenderer);
    }

    public TextDisplay(String text, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, FontRenderer fontRenderer) {
        this(Collections.singletonList(new Tuple<String, Integer>(text, 0xFFFFFF)), point, xAlignment, yAlignment, fontRenderer);
    }

    private static List<Tuple<String, Integer>> getTextsFor(String translationKey, Tuple<String, Integer> ... args) {
        ArrayList<Tuple<String, Integer>> texts = new ArrayList<Tuple<String, Integer>>();
        new TranslationTextComponent(translationKey, (Object[])Arrays.stream(args).map(Tuple::getLeft).toArray(Object[]::new)).func_212637_f().forEachOrdered(tt -> {
            String t = tt.getString();
            texts.add(new Tuple<String, Integer>(t, Arrays.stream(args).filter(p -> ((String)p._1).equals(t)).map(Tuple::getRight).findFirst().orElse(0xFFFFFF)));
        });
        return texts;
    }

    public TextDisplay(List<Tuple<String, Integer>> texts, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, FontRenderer fontRenderer) {
        this.texts = texts;
        this.widths = texts.stream().map(tuple -> fontRenderer.func_78256_a((String)tuple._1)).collect(Collectors.toList());
        int n = this.widths.stream().reduce(0, Integer::sum);
        fontRenderer.getClass();
        this.rect = new Rect(point, n, 9, xAlignment, yAlignment);
        this.fontRenderer = fontRenderer;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int x = this.rect.point.x;
        for (int i = 0; i < this.texts.size(); ++i) {
            Tuple<String, Integer> textAndColor = this.texts.get(i);
            this.fontRenderer.func_175063_a((String)textAndColor._1, (float)x, (float)this.rect.point.y, ((Integer)textAndColor._2).intValue());
            x += this.widths.get(i).intValue();
        }
    }
}

