/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.registry;

import gollorum.signpost.minecraft.block.PostBlock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="signpost", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ColorRegistry {
    private static final IBlockColor getOverlayBlockColor = (blockState, world, blockPos, tintIndex) -> {
        if (world == null || blockPos == null) {
            return -1;
        }
        switch (tintIndex) {
            case 1: {
                return BiomeColors.func_228358_a_((ILightReader)world, (BlockPos)blockPos);
            }
            case 2: {
                return BiomeColors.func_228361_b_((ILightReader)world, (BlockPos)blockPos);
            }
            case 3: {
                return BiomeColors.func_228363_c_((ILightReader)world, (BlockPos)blockPos);
            }
        }
        return -1;
    };

    @SubscribeEvent
    static void onBlockColor(ColorHandlerEvent.Block event) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            event.getBlockColors().func_186722_a(getOverlayBlockColor, new Block[]{variant.block});
        }
    }

    @SubscribeEvent
    static void onItemColor(ColorHandlerEvent.Item event) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            event.getItemColors().func_199877_a(ColorRegistry::getOverlayItemColor, new IItemProvider[]{variant.block});
            event.getBlockColors().func_186722_a(getOverlayBlockColor, new Block[]{variant.block});
        }
    }

    private static int getOverlayItemColor(ItemStack itemStack, int tintIndex) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null) {
            return -1;
        }
        switch (tintIndex) {
            case 1: {
                return BiomeColors.func_228358_a_((ILightReader)world, (BlockPos)player.func_180425_c());
            }
            case 2: {
                return BiomeColors.func_228361_b_((ILightReader)world, (BlockPos)player.func_180425_c());
            }
            case 3: {
                return BiomeColors.func_228363_c_((ILightReader)world, (BlockPos)player.func_180425_c());
            }
        }
        return -1;
    }

    public static int getOverlayColor(int tintIndex, World world, BlockPos pos) {
        switch (tintIndex) {
            case 1: {
                return BiomeColors.func_228358_a_((ILightReader)world, (BlockPos)pos);
            }
            case 2: {
                return BiomeColors.func_228361_b_((ILightReader)world, (BlockPos)pos);
            }
            case 3: {
                return BiomeColors.func_228363_c_((ILightReader)world, (BlockPos)pos);
            }
        }
        return -1;
    }
}

