/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.registry;

import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="signpost", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ResourceRegistry {
    private static final Set<Class<? extends SignBlockPart>> signTypesToHandle = new HashSet<Class<? extends SignBlockPart>>();

    @SubscribeEvent
    static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            for (ResourceLocation texture : Overlay.getAllOverlays().stream().flatMap(o -> signTypesToHandle.stream().map(o::textureFor)).collect(Collectors.toList())) {
                event.addSprite(texture);
            }
        }
    }

    static {
        signTypesToHandle.add(SmallWideSignBlockPart.class);
        signTypesToHandle.add(SmallShortSignBlockPart.class);
        signTypesToHandle.add(LargeSignBlockPart.class);
    }
}

