/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;

public class PostItemRenderer
extends ItemStackTileEntityRenderer {
    private static PostItemRenderer instance;

    public static PostItemRenderer getInstance() {
        if (instance == null) {
            instance = new PostItemRenderer();
        }
        return instance;
    }

    private PostItemRenderer() {
    }

    public void func_228364_a_(ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        List<Object> parts;
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem) || !(((BlockItem)stack.func_77973_b()).func_179223_d() instanceof PostBlock)) {
            Signpost.LOGGER.error("Tried to render a non-post item with the post renderer");
            super.func_228364_a_(stack, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay);
            return;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Parts")) {
            parts = PostTile.readPartInstances(stack.func_77978_p().func_74775_l("Parts"));
        } else {
            parts = new ArrayList();
            PostBlock.ModelType type = ((PostBlock)((BlockItem)stack.func_77973_b()).func_179223_d()).type;
            parts.add(new BlockPartInstance(new PostBlockPart(type.postTexture), Vector3.ZERO));
            parts.add(new BlockPartInstance(new SmallWideSignBlockPart(Angle.fromDegrees(180.0f), "", true, type.mainTexture, type.secondaryTexture, Optional.empty(), 0xFFFFFF, Optional.empty(), ItemStack.field_190927_a, type, false), new Vector3(0.0f, 0.75f, 0.0f)));
        }
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            for (BlockPartInstance now : parts) {
                RenderingUtil.wrapInMatrixEntry(matrixStack, () -> BlockPartRenderer.renderGuiDynamic(now.blockPart, matrixStack, now.offset, renderTypeBuffer, combinedLight, combinedOverlay));
            }
            if (renderTypeBuffer instanceof IRenderTypeBuffer.Impl) {
                ((IRenderTypeBuffer.Impl)renderTypeBuffer).func_228461_a_();
            }
        });
    }
}

