/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.BlockPartInstance;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;

public class PostRenderer
extends TileEntityRenderer<PostTile> {
    private static final double randomOffset = 0.001;

    public PostRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(PostTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        Random random = new Random();
        long rand = tile.hashCode();
        random.setSeed(rand);
        SortedSet destructionProgresses = (SortedSet)Minecraft.func_71410_x().field_71438_f.field_228407_B_.get(tile.func_174877_v().func_218275_a());
        Set partsBeingBroken = destructionProgresses == null ? null : destructionProgresses.stream().map(progress -> Optional.ofNullable(tile.func_145831_w().func_73045_a(progress.field_73115_a)).flatMap(tile::trace).map(res -> res.part)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        boolean shouldUseOriginalBuffer = partsBeingBroken == null || partsBeingBroken.isEmpty() || partsBeingBroken.stream().anyMatch(i -> i.blockPart instanceof PostBlockPart);
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            for (BlockPartInstance now : tile.getParts()) {
                RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
                    matrixStack.func_227861_a_((double)now.offset.x + 0.001 * random.nextDouble(), (double)now.offset.y + 0.001 * random.nextDouble(), (double)now.offset.z + 0.001 * random.nextDouble());
                    BlockPartRenderer.renderDynamic(now.blockPart, tile, this.field_228858_b_, matrixStack, (IRenderTypeBuffer)(shouldUseOriginalBuffer || partsBeingBroken.contains(now) ? buffer : Minecraft.func_71410_x().func_228019_au_().func_228487_b_()), combinedLight, combinedOverlay, random, rand);
                });
            }
        });
    }
}

