/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gollorum.signpost.minecraft.data.PostModel;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;

public class RenderingUtil {
    private static final Lazy<BlockModelRenderer> Renderer = Lazy.of(() -> Minecraft.func_71410_x().func_175602_ab().func_175019_b());
    private static final Lazy<Tessellator> Tesselator = Lazy.of(Tessellator::func_178181_a);
    private static final Lazy<BufferBuilder> BufferBuilder = Lazy.of(() -> ((Tessellator)Tesselator.get()).func_178180_c());

    public static IBakedModel loadModel(ResourceLocation location) {
        return ModelLoader.instance().getBakedModel(location, (IModelTransform)new SimpleModelTransform(TransformationMatrix.func_227983_a_()), Material::func_229314_c_);
    }

    public static IBakedModel loadModel(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        ResourceLocation textLoc = RenderingUtil.trim(textureLocation);
        return ModelLoader.instance().func_209597_a(modelLocation).func_225613_a_((ModelBakery)ModelLoader.instance(), m -> (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(m.func_229310_a_()).apply(textLoc), (IModelTransform)new SimpleModelTransform(TransformationMatrix.func_227983_a_()), modelLocation);
    }

    public static IBakedModel loadModel(ResourceLocation modelLocation, ResourceLocation textureLocation1, ResourceLocation textureLocation2) {
        ResourceLocation textLoc1 = RenderingUtil.trim(textureLocation1);
        ResourceLocation textLoc2 = RenderingUtil.trim(textureLocation2);
        return ModelLoader.instance().func_209597_a(modelLocation).func_225613_a_((ModelBakery)ModelLoader.instance(), m -> (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(m.func_229310_a_()).apply(m.func_229313_b_().equals((Object)PostModel.mainTextureMarker) ? textLoc1 : textLoc2), (IModelTransform)new SimpleModelTransform(TransformationMatrix.func_227983_a_()), modelLocation);
    }

    public static ResourceLocation trim(ResourceLocation textureLocation) {
        if (textureLocation.func_110623_a().startsWith("textures/")) {
            textureLocation = new ResourceLocation(textureLocation.func_110624_b(), textureLocation.func_110623_a().substring("textures/".length()));
        }
        if (textureLocation.func_110623_a().endsWith(".png")) {
            textureLocation = new ResourceLocation(textureLocation.func_110624_b(), textureLocation.func_110623_a().substring(0, textureLocation.func_110623_a().length() - ".png".length()));
        }
        return textureLocation;
    }

    public static void render(MatrixStack matrix, Consumer<RenderModel> inner) {
        matrix.func_227860_a_();
        inner.accept((model, world, state, pos, buffer, checkSides, random, rand, combinedOverlay, rotationMatrix) -> ((BlockModelRenderer)Renderer.get()).func_228802_a_((ILightReader)world, model, state, pos, matrix, buffer, checkSides, random, rand, combinedOverlay));
        matrix.func_227865_b_();
    }

    public static int drawString(FontRenderer fontRenderer, String text, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int color, int maxWidth, boolean dropShadow) {
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        int textWidth = fontRenderer.func_78256_a(text);
        float scale = Math.min(1.0f, (float)maxWidth / (float)textWidth);
        float f = (float)Rect.xCoordinateFor(point.x, maxWidth, xAlignment) + (float)maxWidth * 0.5f;
        int n = point.y;
        fontRenderer.getClass();
        float f2 = Rect.yCoordinateFor(n, 9, yAlignment);
        fontRenderer.getClass();
        Matrix4f matrix = Matrix4f.func_226599_b_((float)f, (float)(f2 + 9.0f * 0.5f), (float)100.0f);
        if (scale < 1.0f) {
            matrix.func_226595_a_(Matrix4f.func_226593_a_((float)scale, (float)scale, (float)scale));
        }
        float f3 = (float)(maxWidth - Math.min(maxWidth, textWidth)) * 0.5f;
        fontRenderer.getClass();
        int i = fontRenderer.func_228079_a_(text, f3, (float)(-9) * 0.5f, color, dropShadow, matrix, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        buffer.func_228461_a_();
        return i;
    }

    public static void renderGui(IBakedModel model, MatrixStack matrixStack, int color, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset, RenderType renderType, Consumer<MatrixStack> alsoDo) {
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.func_227861_a_((double)center.x, (double)center.y, 0.0);
            matrixStack.func_227862_a_(scale, -scale, scale);
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, pitch.radians(), false));
            if (isFlipped) {
                matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, (float)Math.PI, false));
            }
            IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            RenderingUtil.renderGui(model, matrixStack, color, offset, yaw, renderTypeBuffer.getBuffer(renderType), 0xF000F0, OverlayTexture.field_229196_a_, alsoDo);
            renderTypeBuffer.func_228461_a_();
        });
    }

    public static void renderGui(IBakedModel model, MatrixStack matrixStack, int color, Vector3 offset, Angle yaw, IVertexBuilder builder, int combinedLight, int combinedOverlay, Consumer<MatrixStack> alsoDo) {
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, yaw.radians(), false));
            matrixStack.func_227861_a_((double)offset.x, (double)offset.y, (double)offset.z);
            RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
                ArrayList<Direction> allDirections = new ArrayList<Direction>(Arrays.asList(Direction.values()));
                allDirections.add(null);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).setBlurMipmap(false, false);
                float r = (float)Colors.getRed(color) / 255.0f;
                float g = (float)Colors.getGreen(color) / 255.0f;
                float b = (float)Colors.getBlue(color) / 255.0f;
                Random random = new Random();
                for (Direction dir : allDirections) {
                    random.setSeed(42L);
                    for (BakedQuad quad : model.getQuads(null, dir, random, (IModelData)EmptyModelData.INSTANCE)) {
                        builder.func_227889_a_(matrixStack.func_227866_c_(), quad, r, g, b, combinedLight, combinedOverlay);
                    }
                }
            });
            alsoDo.accept(matrixStack);
        });
    }

    public static void wrapInMatrixEntry(MatrixStack matrixStack, Runnable thenDo) {
        matrixStack.func_227860_a_();
        thenDo.run();
        matrixStack.func_227865_b_();
    }

    public static IBakedModel withTintIndex(final IBakedModel original, final int tintIndex) {
        return new IBakedModel(){

            public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
                return original.func_200117_a(state, side, rand).stream().map(q -> new BakedQuad(q.func_178209_a(), tintIndex, q.func_178210_d(), q.func_187508_a(), q.shouldApplyDiffuseLighting())).collect(Collectors.toList());
            }

            public boolean func_177555_b() {
                return original.func_177555_b();
            }

            public boolean func_177556_c() {
                return original.func_177556_c();
            }

            public boolean func_230044_c_() {
                return original.func_230044_c_();
            }

            public boolean func_188618_c() {
                return original.func_188618_c();
            }

            public TextureAtlasSprite func_177554_e() {
                return original.func_177554_e();
            }

            public ItemOverrideList func_188617_f() {
                return original.func_188617_f();
            }
        };
    }

    public static interface RenderModel {
        public void render(IBakedModel var1, World var2, BlockState var3, BlockPos var4, IVertexBuilder var5, boolean var6, Random var7, long var8, int var10, Matrix4f var11);
    }
}

