/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import gollorum.signpost.Signpost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Inventory {
    private static List<ItemStack> getAllItemStack(PlayerEntity player) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(player.func_184614_ca());
        ret.add(player.func_184592_cb());
        ret.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
        return ret;
    }

    public static int getItemCount(PlayerEntity player, Item item) {
        int count = 0;
        for (ItemStack currentStack : Inventory.getAllItemStack(player)) {
            if (!currentStack.func_77973_b().equals(item)) continue;
            count += currentStack.func_190916_E();
        }
        return count;
    }

    public static void tryPay(PlayerEntity player, ItemStack itemStack, Consumer<PlayerEntity> onSuccess) {
        if (!player.func_184812_l_()) {
            if (Inventory.tryConsume(player, itemStack)) {
                onSuccess.accept(player);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("signpost.too_expensive", new Object[]{itemStack.func_190916_E(), new TranslationTextComponent(itemStack.func_77973_b().func_77658_a(), new Object[0])}));
            }
        } else {
            onSuccess.accept(player);
        }
    }

    public static boolean tryConsume(PlayerEntity player, ItemStack itemStack) {
        if (itemStack.func_190916_E() <= 0) {
            return true;
        }
        if (Inventory.getItemCount(player, itemStack.func_77973_b()) >= itemStack.func_190916_E()) {
            int remainingItems = itemStack.func_190916_E();
            for (ItemStack currentStack : Inventory.getAllItemStack(player)) {
                if (!currentStack.func_77973_b().equals(itemStack.func_77973_b())) continue;
                currentStack.func_190920_e((remainingItems -= currentStack.func_190916_E()) > 0 ? 0 : -remainingItems);
                if (remainingItems > 0) continue;
                return true;
            }
            if (remainingItems <= 0) {
                return true;
            }
            Signpost.LOGGER.error("Tried to consume more items than were present");
        }
        return false;
    }
}

