/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import gollorum.signpost.Signpost;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class TileEntityUtils {
    public static <T> Optional<T> findTileEntity(IBlockReader world, BlockPos pos, Class<T> c) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && c.isAssignableFrom(tileEntity.getClass())) {
            return Optional.of(tileEntity);
        }
        return Optional.empty();
    }

    public static <T> void delayUntilTileEntityExists(IWorld world, BlockPos pos, Class<T> c, Consumer<T> action, int timeout, Optional<Runnable> onTimeOut) {
        Delay.untilIsPresent(() -> TileEntityUtils.findTileEntity((IBlockReader)world, pos, c), action, timeout, world.func_201670_d(), onTimeOut);
    }

    public static <T> Optional<T> findTileEntity(ResourceLocation dimensionKeyLocation, boolean isRemote, BlockPos blockPos, Class<T> c) {
        return TileEntityUtils.findWorld(dimensionKeyLocation, isRemote).flatMap(world -> TileEntityUtils.findTileEntity((IBlockReader)world, blockPos, c));
    }

    public static Optional<World> findWorld(ResourceLocation dimensionKeyLocation, boolean isClient) {
        return isClient ? (Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().getRegistryName().equals((Object)dimensionKeyLocation) ? Optional.of(Minecraft.func_71410_x().field_71441_e) : Optional.empty()) : (Signpost.getServerType().isServer ? Optional.ofNullable(DimensionType.func_193417_a((ResourceLocation)dimensionKeyLocation)).map(arg_0 -> ((MinecraftServer)Signpost.getServerInstance()).func_71218_a(arg_0)) : Optional.empty());
    }

    public static Optional<World> toWorld(Either<World, ResourceLocation> either, boolean onClient) {
        return either.match(Optional::of, right -> TileEntityUtils.findWorld(right, onClient));
    }

    public static <T> Optional<T> findTileEntityAt(WorldLocation location, Class<T> c, boolean onClient) {
        return TileEntityUtils.toWorld(location.world, onClient).map(w -> w.func_175625_s(location.blockPos)).flatMap(tile -> c.isAssignableFrom(tile.getClass()) ? Optional.of(tile) : Optional.empty());
    }

    public static <T> void delayUntilTileEntityExistsAt(WorldLocation location, Class<T> c, Consumer<T> action, int timeout, boolean onClient, Optional<Runnable> onTimeOut) {
        Delay.untilIsPresent(() -> TileEntityUtils.findTileEntityAt(location, c, onClient), action, timeout, onClient, onTimeOut);
    }

    public static <T> Optional<T> findTileEntityClient(ResourceLocation dimensionKeyLocation, BlockPos pos, Class<T> c) {
        return Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().getRegistryName().equals((Object)dimensionKeyLocation) ? TileEntityUtils.findTileEntity((IBlockReader)Minecraft.func_71410_x().field_71441_e, pos, c) : Optional.empty();
    }
}

