/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mojang.datafixers.Dynamic;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SignpostJigsawPiece
extends SingleJigsawPiece {
    private static final float smallSignRatio = 0.5f;
    private static Map<BlockPos, List<WaystoneHandle.Vanilla>> waystonesTargetedByVillage;
    private static Map<BlockPos, Integer> signpostCountForVillage;
    public final boolean isZombie;

    public static void reset() {
        waystonesTargetedByVillage = new HashMap<BlockPos, List<WaystoneHandle.Vanilla>>();
        signpostCountForVillage = new HashMap<BlockPos, Integer>();
    }

    public SignpostJigsawPiece(String template, List<StructureProcessor> structureProcessorListSupplier, JigsawPattern.PlacementBehaviour placementBehaviour, boolean isZombie) {
        super(template, structureProcessorListSupplier, placementBehaviour);
        this.isZombie = isZombie;
    }

    public SignpostJigsawPiece(Dynamic<?> dynamic) {
        super(dynamic);
        this.isZombie = dynamic.get("isZombie").asBoolean(false);
    }

    public boolean func_225575_a_(TemplateManager templateManager, IWorld seedReader, ChunkGenerator<?> chunkGenerator, BlockPos pieceLocation, Rotation rotation, MutableBoundingBox boundingBox, Random random) {
        PlacementSettings placementSettings;
        if (!((Boolean)Config.Server.worldGen.isVillageGenerationEnabled.get()).booleanValue()) {
            return false;
        }
        BlockPos villageLocation = Feature.field_214550_p.func_211405_a(seedReader.func_201672_e(), chunkGenerator, pieceLocation, 100, false);
        if (signpostCountForVillage.getOrDefault(villageLocation, 0) >= (Integer)Config.Server.worldGen.maxSignpostsPerVillage.get()) {
            return false;
        }
        Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets = SignpostJigsawPiece.fetchPossibleTargets(pieceLocation, villageLocation, random);
        if (possibleTargets.isEmpty()) {
            return false;
        }
        Template template = templateManager.func_200220_a(this.field_214861_a);
        if (template.func_189962_a(seedReader, pieceLocation, placementSettings = this.func_214860_a(rotation, boundingBox), 18)) {
            Collection<WaystoneHandle.Vanilla> freshlyUsedWaystones = this.populateSignPostGeneration(placementSettings, pieceLocation, seedReader, random, possibleTargets);
            waystonesTargetedByVillage.computeIfAbsent(villageLocation, k -> new ArrayList()).addAll(freshlyUsedWaystones);
            for (Template.BlockInfo blockInfo : Template.processBlockInfos((Template)template, (IWorld)seedReader, (BlockPos)pieceLocation, (PlacementSettings)placementSettings, (List)this.func_214857_a(templateManager, pieceLocation, rotation, false))) {
                this.func_214846_a(seedReader, blockInfo, pieceLocation, rotation, random, boundingBox);
            }
            signpostCountForVillage.put(villageLocation, signpostCountForVillage.getOrDefault(villageLocation, 0) + 1);
            return true;
        }
        return false;
    }

    private static Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> fetchPossibleTargets(BlockPos pieceLocation, BlockPos villageLocation, Random random) {
        return SignpostJigsawPiece.allWaystoneTargets(villageLocation).map(e -> new Tuple<Tuple, Float>((Tuple)e, Float.valueOf((float)Math.sqrt(((BlockPos)e._1).func_177951_i((Vec3i)pieceLocation)) * (0.5f + random.nextFloat())))).sorted((e1, e2) -> Float.compare(((Float)e1._2).floatValue(), ((Float)e2._2).floatValue())).map(Tuple::getLeft).filter(e -> WaystoneLibrary.getInstance().contains((WaystoneHandle.Vanilla)e._2)).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> allWaystoneTargets(BlockPos villageLocation) {
        Stream villageWaystones = SignpostJigsawPiece.villageWaystonesExceptSelf(villageLocation);
        return ((Boolean)Config.Server.worldGen.villagesOnlyTargetVillages.get() != false ? villageWaystones : Streams.concat((Stream[])new Stream[]{villageWaystones, SignpostJigsawPiece.nonVillageWaystones()})).filter(e -> !waystonesTargetedByVillage.containsKey(villageLocation) || !waystonesTargetedByVillage.get(villageLocation).contains(e._2));
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> villageWaystonesExceptSelf(BlockPos villageLocation) {
        return WaystoneJigsawPiece.getAllEntries().stream().filter(e -> !((BlockPos)e.getKey()).equals((Object)villageLocation)).map(Tuple::from);
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> nonVillageWaystones() {
        return WaystoneLibrary.getInstance().getAllWaystoneInfo().stream().map(info -> new Tuple<BlockPos, WaystoneHandle.Vanilla>(info.locationData.block.blockPos, info.handle)).filter(t -> WaystoneJigsawPiece.getAllEntries().stream().noneMatch(e -> ((WaystoneHandle.Vanilla)e.getValue()).equals(t._2)));
    }

    private Collection<WaystoneHandle.Vanilla> populateSignPostGeneration(PlacementSettings placementSettings, BlockPos pieceLocation, IWorld world, Random random, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets) {
        Direction facing = placementSettings.func_186215_c().func_185831_a(Direction.WEST);
        Direction left = placementSettings.func_186215_c().func_185831_a(Direction.SOUTH);
        BlockPos lowerPos = pieceLocation.func_177972_a(facing.func_176734_d()).func_177972_a(left).func_177984_a();
        BlockPos upperPos = lowerPos.func_177984_a();
        Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> upperSignResult = this.makeSign(random, facing, world, upperPos, possibleTargets, 0.75f);
        Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> lowerSignResult = this.makeSign(random, facing, world, upperPos, possibleTargets, 0.25f);
        TileEntityUtils.delayUntilTileEntityExists((IWorld)world.func_201672_e(), upperPos, PostTile.class, tile -> {
            ((Consumer)upperSignResult._2).accept(tile);
            ((Consumer)lowerSignResult._2).accept(tile);
            tile.func_70296_d();
        }, 20, Optional.of(() -> Signpost.LOGGER.error("Could not populate generated signpost at " + upperPos + ": TileEntity was not constructed.")));
        ArrayList<WaystoneHandle.Vanilla> ret = new ArrayList<WaystoneHandle.Vanilla>();
        ret.addAll((Collection)upperSignResult._1);
        ret.addAll((Collection)lowerSignResult._1);
        return ret;
    }

    public Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> makeSign(Random random, Direction facing, IWorld world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        if (possibleTargets.isEmpty()) {
            return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.emptySet(), x -> {});
        }
        return random.nextFloat() < 0.5f ? this.makeShortSigns(facing, world, tilePos, possibleTargets, y) : this.makeWideSign(facing, world, tilePos, possibleTargets, y);
    }

    private Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> makeWideSign(Direction facing, IWorld world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Tuple<BlockPos, WaystoneHandle.Vanilla> target = possibleTargets.poll();
        if (target == null) {
            return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.emptySet(), x -> {});
        }
        WaystoneData targetData = WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)target._2);
        Angle rotation = SignBlockPart.pointingAt(tilePos, (BlockPos)target._1);
        Consumer<PostTile> onTileFetched = tile -> {
            if (tile.getParts().stream().anyMatch(instance -> !(instance.blockPart instanceof PostBlockPart) && SignpostJigsawPiece.isNearly(instance.offset.y, y))) {
                return;
            }
            tile.addPart(new BlockPartInstance(new SmallWideSignBlockPart(rotation, targetData.name, SignpostJigsawPiece.shouldFlip(facing, rotation), tile.modelType.mainTexture, tile.modelType.secondaryTexture, this.overlayFor(world, tilePos), 0, Optional.of(target._2), ItemStack.field_190927_a, tile.modelType, false), new Vector3(0.0f, y, 0.0f)), ItemStack.field_190927_a, PlayerHandle.Invalid);
        };
        return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.singleton(target._2), onTileFetched);
    }

    private static boolean isNearly(float a, float b) {
        return Math.abs(a - b) < 1.0E-5f;
    }

    private Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> makeShortSigns(Direction facing, IWorld world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Tuple<BlockPos, WaystoneHandle.Vanilla> target = possibleTargets.poll();
        if (target == null) {
            return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.emptySet(), x -> {});
        }
        WaystoneData targetData = WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)target._2);
        Angle rotation = SignBlockPart.pointingAt(tilePos, (BlockPos)target._1);
        boolean shouldFlip = SignpostJigsawPiece.shouldFlip(facing, rotation);
        Optional<Overlay> overlay = this.overlayFor(world, tilePos);
        ArrayList<Consumer<PostTile>> onTileFetched = new ArrayList<Consumer<PostTile>>();
        onTileFetched.add(tile -> tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(rotation, targetData.name, shouldFlip, tile.modelType.mainTexture, tile.modelType.secondaryTexture, overlay, 0, Optional.of(target._2), ItemStack.field_190927_a, tile.modelType, false), new Vector3(0.0f, y, 0.0f)), ItemStack.field_190927_a, PlayerHandle.Invalid));
        Tuple<BlockPos, WaystoneHandle.Vanilla> secondTarget = possibleTargets.poll();
        ArrayList<Tuple<BlockPos, WaystoneHandle.Vanilla>> skippedTargets = new ArrayList<Tuple<BlockPos, WaystoneHandle.Vanilla>>();
        while (secondTarget != null) {
            WaystoneData secondTargetData = WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)secondTarget._2);
            Angle secondRotation = SignBlockPart.pointingAt(tilePos, (BlockPos)secondTarget._1);
            boolean shouldSecondFlip = SignpostJigsawPiece.shouldFlip(facing, secondRotation);
            if (shouldSecondFlip == shouldFlip) {
                skippedTargets.add(secondTarget);
                secondTarget = possibleTargets.poll();
                continue;
            }
            WaystoneHandle.Vanilla secondTargetHandle = (WaystoneHandle.Vanilla)secondTarget._2;
            onTileFetched.add(tile -> tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(secondRotation, secondTargetData.name, shouldSecondFlip, tile.modelType.mainTexture, tile.modelType.secondaryTexture, overlay, 0, Optional.of(secondTargetHandle), ItemStack.field_190927_a, tile.modelType, false), new Vector3(0.0f, y, 0.0f)), ItemStack.field_190927_a, PlayerHandle.Invalid));
            break;
        }
        skippedTargets.addAll(possibleTargets);
        possibleTargets.clear();
        possibleTargets.addAll(skippedTargets);
        return new Tuple<ImmutableList, Consumer<PostTile>>(secondTarget == null ? Collections.singleton(target._2) : ImmutableList.of(target._2, secondTarget._2), tile -> {
            if (tile.getParts().stream().noneMatch(instance -> !(instance.blockPart instanceof PostBlockPart) && SignpostJigsawPiece.isNearly(instance.offset.y, y))) {
                for (Consumer now : onTileFetched) {
                    now.accept(tile);
                }
            }
        });
    }

    private static boolean shouldFlip(Direction facing, Angle signRotation) {
        float degrees = signRotation.add(Angle.fromDegrees(facing.func_185119_l())).normalized().degrees();
        return degrees < -90.0f || degrees > 90.0f;
    }

    private Optional<Overlay> overlayFor(IWorld world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        if (biome.func_201850_b((IWorldReader)world, pos) || biome.func_201851_b() == Biome.RainType.SNOW || biome.func_201856_r() == Biome.Category.ICY) {
            return Optional.of(Overlay.Snow);
        }
        if (biome.func_201856_r() == Biome.Category.JUNGLE) {
            return Optional.of(Overlay.Vine);
        }
        if (biome.func_76736_e() || this.isZombie) {
            return Optional.of(Overlay.Gras);
        }
        return Optional.empty();
    }

    public IJigsawDeserializer func_214853_a() {
        return JigsawDeserializers.signpost;
    }

    public String toString() {
        return "SingleSignpost[" + this.field_214861_a + "]";
    }
}

