/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.google.common.collect.Streams;
import com.mojang.datafixers.Dynamic;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ResourceLocationSerializer;
import gollorum.signpost.worldgen.VillageNamesProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class WaystoneJigsawPiece
extends SingleJigsawPiece {
    public static final Map<BlockPos, WaystoneHandle.Vanilla> generatedWaystones = new HashMap<BlockPos, WaystoneHandle.Vanilla>();
    public static final Map<ChunkEntryKey, WaystoneHandle.Vanilla> generatedWaystonesByChunk = new HashMap<ChunkEntryKey, WaystoneHandle.Vanilla>();

    public static void reset() {
        generatedWaystones.clear();
    }

    public static INBT serialize() {
        ListNBT ret = new ListNBT();
        ret.addAll((Collection)Streams.zip(generatedWaystones.entrySet().stream(), generatedWaystonesByChunk.keySet().stream(), (e, c) -> {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("refPos", (INBT)BlockPosSerializer.INSTANCE.write(e.getKey()));
            compound.func_218657_a("chunkEntryKey", (INBT)ChunkEntryKey.serializer.write(c));
            compound.func_218657_a("waystone", (INBT)WaystoneHandle.Vanilla.Serializer.write((WaystoneHandle.Vanilla)e.getValue()));
            return compound;
        }).collect(Collectors.toList()));
        return ret;
    }

    public static void deserialize(ListNBT nbt) {
        generatedWaystones.clear();
        generatedWaystones.putAll(nbt.stream().collect(Collectors.toMap(entry -> BlockPosSerializer.INSTANCE.read(((CompoundNBT)entry).func_74775_l("refPos")), entry -> WaystoneHandle.Vanilla.Serializer.read(((CompoundNBT)entry).func_74775_l("waystone")))));
        generatedWaystonesByChunk.clear();
        generatedWaystonesByChunk.putAll(nbt.stream().collect(Collectors.toMap(entry -> ChunkEntryKey.serializer.read(((CompoundNBT)entry).func_74775_l("chunkEntryKey")), entry -> WaystoneHandle.Vanilla.Serializer.read(((CompoundNBT)entry).func_74775_l("waystone")))));
    }

    public WaystoneJigsawPiece(String template, List<StructureProcessor> structureProcessorListSupplier, JigsawPattern.PlacementBehaviour placementBehaviour) {
        super(template, structureProcessorListSupplier, placementBehaviour);
    }

    public WaystoneJigsawPiece(Dynamic<?> dynamic) {
        super(dynamic);
    }

    public boolean func_225575_a_(TemplateManager templateManager, IWorld seedReader, ChunkGenerator<?> chunkGenerator, BlockPos pieceLocation, Rotation rotation, MutableBoundingBox boundingBox, Random random) {
        if (!((Boolean)Config.Server.worldGen.isVillageGenerationEnabled.get()).booleanValue()) {
            return false;
        }
        BlockPos villageLocation = Feature.field_214550_p.func_211405_a(seedReader.func_201672_e(), chunkGenerator, pieceLocation, 100, false);
        if (generatedWaystones.containsKey(villageLocation)) {
            return false;
        }
        List<ModelWaystone> allowedWaystones = WaystoneJigsawPiece.getAllowedWaystones();
        if (allowedWaystones.size() == 0) {
            Signpost.LOGGER.warn("Tried to generate a waystone, but the list of allowed waystones was empty.");
            return false;
        }
        PlacementSettings placementSettings = this.func_214860_a(rotation, boundingBox);
        Direction facing = placementSettings.func_186215_c().func_185831_a(Direction.WEST);
        Direction left = placementSettings.func_186215_c().func_185831_a(Direction.SOUTH);
        BlockPos pos = pieceLocation.func_177972_a(facing.func_176734_d()).func_177972_a(left).func_177984_a();
        ModelWaystone waystone = WaystoneJigsawPiece.getWaystoneType(random, allowedWaystones);
        Optional<String> optionalName = VillageNamesProvider.requestFor(pos, villageLocation, (ServerWorld)seedReader.func_201672_e(), random);
        if (!optionalName.isPresent()) {
            Signpost.LOGGER.warn("No name could be generated for waystone at " + pos + ".");
            return false;
        }
        String name = optionalName.get();
        Template template = templateManager.func_200220_a(this.field_214861_a);
        if (template.func_189962_a(seedReader, pieceLocation, placementSettings, 18)) {
            seedReader.func_180501_a(pos, (BlockState)waystone.func_176223_P().func_206870_a((IProperty)ModelWaystone.Facing, (Comparable)facing.func_176734_d()), 18);
            WaystoneLibrary.getInstance().update(name, WaystoneJigsawPiece.locationDataFor(pos, seedReader, facing), null, false);
            WaystoneJigsawPiece.registerGenerated(name, villageLocation, new ChunkEntryKey(new ChunkPos(pos), seedReader.func_201672_e().func_201675_m().func_186058_p().getRegistryName()));
            for (Template.BlockInfo blockInfo : Template.processBlockInfos((Template)template, (IWorld)seedReader, (BlockPos)pieceLocation, (PlacementSettings)placementSettings, (List)this.func_214857_a(templateManager, pieceLocation, rotation, false))) {
                this.func_214846_a(seedReader, blockInfo, pieceLocation, rotation, random, boundingBox);
            }
            return true;
        }
        return false;
    }

    private static WaystoneLocationData locationDataFor(BlockPos pos, IWorld world, Direction facing) {
        return new WaystoneLocationData(new WorldLocation(pos, world.func_201672_e()), WaystoneJigsawPiece.spawnPosFor(world, pos, facing));
    }

    private static Vector3 spawnPosFor(IWorld world, BlockPos waystonePos, Direction facing) {
        int offset;
        BlockPos spawnBlockPos = waystonePos.func_177967_a(facing, 2);
        int maxOffset = 10;
        for (offset = 0; world.func_180495_p(spawnBlockPos).func_196958_f() && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.func_177977_b();
        }
        for (offset = 0; !world.func_180495_p(spawnBlockPos).func_196958_f() && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.func_177984_a();
        }
        return Vector3.fromBlockPos(spawnBlockPos).add(0.5f, 0.0f, 0.5f);
    }

    private static ModelWaystone getWaystoneType(Random random, List<ModelWaystone> allowedWaystones) {
        return allowedWaystones.get(random.nextInt(allowedWaystones.size()));
    }

    private static void registerGenerated(String name, BlockPos referencePos, ChunkEntryKey chunkInfo) {
        WaystoneLibrary.getInstance().getHandleByName(name).ifPresent(handle -> {
            generatedWaystones.put(referencePos, (WaystoneHandle.Vanilla)handle);
            generatedWaystonesByChunk.put(chunkInfo, (WaystoneHandle.Vanilla)handle);
            WaystoneLibrary.getInstance().markDirty();
        });
    }

    public static Set<Map.Entry<BlockPos, WaystoneHandle.Vanilla>> getAllEntries() {
        return generatedWaystones.entrySet();
    }

    private static List<ModelWaystone> getAllowedWaystones() {
        return ModelWaystone.variants.stream().filter(v -> ((List)Config.Server.worldGen.allowedVillageWaystones.get()).contains(v.name)).map(v -> v.block).collect(Collectors.toList());
    }

    public IJigsawDeserializer func_214853_a() {
        return JigsawDeserializers.waystone;
    }

    public String toString() {
        return "SingleSignpostWaystone[" + this.field_214861_a + "]";
    }

    public static class ChunkEntryKey {
        public final ChunkPos chunkPos;
        public final ResourceLocation dimensionKey;
        public static final Serializer serializer = new Serializer();

        public ChunkEntryKey(ChunkPos chunkPos, ResourceLocation dimensionKey) {
            this.chunkPos = chunkPos;
            this.dimensionKey = dimensionKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkEntryKey that = (ChunkEntryKey)o;
            return this.chunkPos.equals((Object)that.chunkPos) && this.dimensionKey.equals((Object)that.dimensionKey);
        }

        public int hashCode() {
            return Objects.hash(this.chunkPos, this.dimensionKey);
        }

        public static class Serializer
        implements CompoundSerializable<ChunkEntryKey> {
            @Override
            public Class<ChunkEntryKey> getTargetClass() {
                return ChunkEntryKey.class;
            }

            @Override
            public CompoundNBT write(ChunkEntryKey key, CompoundNBT compound) {
                compound.func_74768_a("x", key.chunkPos.field_77276_a);
                compound.func_74768_a("z", key.chunkPos.field_77275_b);
                ResourceLocationSerializer.Instance.write(key.dimensionKey, compound);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundNBT compound) {
                return compound.func_74764_b("x") && compound.func_74764_b("z") && ResourceLocationSerializer.Instance.isContainedIn(compound);
            }

            @Override
            public ChunkEntryKey read(CompoundNBT compound) {
                return new ChunkEntryKey(new ChunkPos(compound.func_74762_e("x"), compound.func_74762_e("z")), ResourceLocationSerializer.Instance.read(compound));
            }
        }
    }
}

