/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.networking;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.Signpost;
import gollorum.signpost.Teleport;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.utils.EventDispatcher;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    private static final Event<?>[] EVENTS = new Event[]{new PostTile.PartAddedEvent(), new PostTile.PartMutatedEvent(), new PostTile.PartRemovedEvent(), new Teleport.Request(), new Teleport.RequestGui(), new RequestSignGui(), new RequestSignGui.ForNewSign(), new RequestWaystoneGui(), new BlockRestrictions.NotifyCountChanged()};
    private static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel channel;
    private static final EventDispatcher.Impl.WithPublicDispatch<Unit> onInitialize;

    public static EventDispatcher<Unit> onInitialize() {
        return onInitialize;
    }

    public static void initialize() {
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("signpost", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        int id = 0;
        for (Event<?> event : EVENTS) {
            PacketHandler.register(event, id++);
        }
        onInitialize.dispatch(Unit.INSTANCE, false);
    }

    public static <T> void register(Event<T> event, int id) {
        PacketHandler.register(event.getMessageClass(), event::encode, event::decode, event::handle, id);
    }

    public static <T> void register(Class<T> messageClass, BiConsumer<T, PacketBuffer> encode, Function<PacketBuffer, T> decode, BiConsumer<T, Supplier<NetworkEvent.Context>> handle, int id) {
        channel.registerMessage(id, messageClass, encode, decode, handle);
    }

    public static <T> void sendToServer(T message) {
        channel.sendToServer(message);
    }

    public static <T> void sendTo(T message, NetworkManager manager, NetworkDirection direction) {
        channel.sendTo(message, manager, direction);
    }

    public static <T> void send(PacketDistributor.PacketTarget target, T message) {
        channel.send(target, message);
    }

    public static <T> void sendToTracing(World world, BlockPos pos, Supplier<T> t) {
        if (world == null) {
            Signpost.LOGGER.warn("No world to notify mutation");
        } else if (pos == null) {
            Signpost.LOGGER.warn("No position to notify mutation");
        } else {
            PacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), t.get());
        }
    }

    public static <T> void sendToTracing(TileEntity tile, Supplier<T> t) {
        PacketHandler.sendToTracing(tile.func_145831_w(), tile.func_174877_v(), t);
    }

    public static <T> void sendToAll(T message) {
        channel.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <T> void reply(T message, NetworkEvent.Context context) {
        channel.reply(message, context);
    }

    static {
        onInitialize = new EventDispatcher.Impl.WithPublicDispatch();
    }

    public static interface Event<T> {
        public Class<T> getMessageClass();

        public void encode(T var1, PacketBuffer var2);

        public T decode(PacketBuffer var1);

        public void handle(T var1, NetworkEvent.Context var2);

        default public void handle(T message, Supplier<NetworkEvent.Context> context) {
            NetworkEvent.Context c = context.get();
            c.enqueueWork(() -> {
                if (c.getDirection().getReceptionSide().isClient()) {
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.handle(message, c));
                } else {
                    this.handle(message, c);
                }
            });
            c.setPacketHandled(true);
        }
    }
}

