/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.relations;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.relations.ExternalWaystone;
import gollorum.signpost.utils.EventDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class ExternalWaystoneLibrary {
    private static final EventDispatcher.Impl.WithPublicDispatch<ExternalWaystoneLibrary> _onInitialize = new EventDispatcher.Impl.WithPublicDispatch();
    private static ExternalWaystoneLibrary instance;
    private final List<Adapter> adapters = new ArrayList<Adapter>();

    public static EventDispatcher<ExternalWaystoneLibrary> onInitialize() {
        return _onInitialize;
    }

    public static ExternalWaystoneLibrary getInstance() {
        return instance;
    }

    private ExternalWaystoneLibrary() {
    }

    public static void initialize() {
        instance = new ExternalWaystoneLibrary();
        _onInitialize.dispatch(instance, false);
    }

    public Optional<WaystoneHandle> read(String type, PacketBuffer buffer) {
        for (Adapter adapter : this.adapters) {
            if (!adapter.typeTag().equals(type)) continue;
            return Optional.of(adapter.read(buffer));
        }
        return Optional.empty();
    }

    public Optional<WaystoneHandle> read(String type, CompoundNBT compound) {
        for (Adapter adapter : this.adapters) {
            if (!adapter.typeTag().equals(type)) continue;
            return Optional.of(adapter.read(compound));
        }
        return Optional.empty();
    }

    public void registerAdapter(Adapter adapter) {
        this.adapters.add(adapter);
    }

    public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> consumer) {
        for (Adapter adapter : this.adapters) {
            adapter.requestKnownWaystones(consumer);
        }
    }

    public static interface Adapter {
        public String typeTag();

        public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> var1);

        public WaystoneHandle read(PacketBuffer var1);

        public WaystoneHandle read(CompoundNBT var1);
    }
}

