/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.relations;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.networking.ReflectionEvent;
import gollorum.signpost.relations.ExternalWaystone;
import gollorum.signpost.relations.ExternalWaystoneLibrary;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.serialization.StringSerializer;
import gollorum.signpost.utils.serialization.UuidSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public final class WaystonesAdapter
implements ExternalWaystoneLibrary.Adapter {
    private static WaystonesAdapter instance;
    private final EventDispatcher.Impl.WithPublicDispatch<Collection<ExternalWaystone>> onReply = new EventDispatcher.Impl.WithPublicDispatch();

    private WaystonesAdapter() {
    }

    public static void register() {
        instance = new WaystonesAdapter();
        ExternalWaystoneLibrary.onInitialize().addListener(ex -> ex.registerAdapter(instance));
        PacketHandler.onInitialize().addListener(unit -> {
            PacketHandler.register(new RequestEvent(), -100);
            PacketHandler.register(new ReplyEvent(), -101);
        });
    }

    @Override
    public String typeTag() {
        return "waystones";
    }

    @Override
    public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> consumer) {
        this.onReply.addListener(consumer);
        PacketHandler.sendToServer(new RequestEvent());
    }

    @Override
    public WaystoneHandle read(PacketBuffer buffer) {
        return new Handle(UuidSerializer.INSTANCE.read(buffer));
    }

    @Override
    public WaystoneHandle read(CompoundNBT compound) {
        return new Handle(UuidSerializer.INSTANCE.read(compound));
    }

    public static final class ReplyEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, PacketBuffer buffer) {
            buffer.writeInt(message.waystones.size());
            for (Waystone waystone : message.waystones) {
                buffer.func_179252_a(waystone.wrapped.getWaystoneUid());
            }
        }

        @Override
        public Packet decode(PacketBuffer buffer) {
            int size = buffer.readInt();
            ArrayList<Waystone> waystones = new ArrayList<Waystone>();
            for (int i = 0; i < size; ++i) {
                waystones.add(new Waystone((IWaystone)new WaystoneProxy(buffer.func_179253_g())));
            }
            return new Packet(waystones);
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            instance.onReply.dispatch(new ArrayList<Waystone>(message.waystones), true);
        }

        public static final class Packet {
            public Collection<Waystone> waystones;

            public Packet(Collection<Waystone> waystones) {
                this.waystones = waystones;
            }
        }
    }

    public static final class RequestEvent
    extends ReflectionEvent<RequestEvent> {
        @Override
        public Class<RequestEvent> getMessageClass() {
            return RequestEvent.class;
        }

        @Override
        public void handle(RequestEvent message, NetworkEvent.Context context) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), new ReplyEvent.Packet(PlayerWaystoneManager.getWaystones((PlayerEntity)context.getSender()).stream().map(Waystone::new).collect(Collectors.toList())));
        }
    }

    public static class Handle
    implements ExternalWaystone.Handle {
        public final UUID id;

        public Handle(UUID id) {
            this.id = id;
        }

        @Override
        public String modMark() {
            return "(Waystones)";
        }

        @Override
        public String noTeleportLangKey() {
            return "signpost.no_teleport_waystones_mod";
        }

        @Override
        public void write(PacketBuffer buffer) {
            StringSerializer.instance.write(instance.typeTag(), buffer);
            UuidSerializer.INSTANCE.write(this.id, buffer);
        }

        @Override
        public void write(CompoundNBT compound) {
            compound.func_74778_a("type", instance.typeTag());
            UuidSerializer.INSTANCE.write(this.id, compound);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handle that = (Handle)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static class Waystone
    implements ExternalWaystone {
        public final IWaystone wrapped;

        public Waystone(IWaystone wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public String name() {
            return this.wrapped.getName();
        }

        @Override
        public WorldLocation loc() {
            return new WorldLocation(this.wrapped.getPos(), this.wrapped.getDimensionType().getRegistryName());
        }

        @Override
        public ExternalWaystone.Handle handle() {
            return new Handle(this.wrapped.getWaystoneUid());
        }
    }
}

